/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.item;

import io.github.flemmli97.improvedmobs.api.item.MoveHandler;
import java.util.function.Function;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface ItemUseHandler {
    default public void start(LivingEntity entity, LivingEntity target, InteractionHand hand) {
    }

    default public void onPrepare(LivingEntity entity, LivingEntity target, InteractionHand hand) {
    }

    default public int attackDelay(LivingEntity entity, ItemStack stack) {
        return 0;
    }

    public void use(LivingEntity var1, LivingEntity var2, InteractionHand var3);

    default public boolean canUse(LivingEntity entity, ItemStack stack) {
        return true;
    }

    public PreferredHand preferredHand();

    public int cooldown(LivingEntity var1);

    public boolean matches(Item var1);

    @Nullable
    default public Function<Mob, MoveHandler> movementType() {
        return null;
    }

    default public EquipmentSlot defaultedSlot() {
        return this.preferredHand().slot;
    }

    public static enum PreferredHand {
        MAINHAND(EquipmentSlot.MAINHAND),
        OFFHAND(EquipmentSlot.OFFHAND),
        ANY(EquipmentSlot.MAINHAND);

        public final EquipmentSlot slot;

        private PreferredHand(EquipmentSlot slot) {
            this.slot = slot;
        }
    }
}

