/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.item;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.api.item.ItemUseHandler;
import io.github.flemmli97.improvedmobs.api.item.impl.BowHandler;
import io.github.flemmli97.improvedmobs.api.item.impl.CrossbowHandler;
import io.github.flemmli97.improvedmobs.api.item.impl.EnchantedBookHandler;
import io.github.flemmli97.improvedmobs.api.item.impl.EnderpearlHandler;
import io.github.flemmli97.improvedmobs.api.item.impl.FishingRodHandler;
import io.github.flemmli97.improvedmobs.api.item.impl.FlintAndSteelHandler;
import io.github.flemmli97.improvedmobs.api.item.impl.LavaBucketHandler;
import io.github.flemmli97.improvedmobs.api.item.impl.ShieldHandler;
import io.github.flemmli97.improvedmobs.api.item.impl.SimpleProjectileHandler;
import io.github.flemmli97.improvedmobs.api.item.impl.ThrowablePotionHandler;
import io.github.flemmli97.improvedmobs.api.item.impl.TntHandler;
import io.github.flemmli97.improvedmobs.api.item.impl.TridentHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Items;

public class ItemUseRegistry {
    private static final Map<ResourceLocation, ItemUseHandler> REGISTRY = new HashMap<ResourceLocation, ItemUseHandler>();
    private static final Map<ItemUseHandler, ResourceLocation> LOOKUP_REGISTRY = new HashMap<ItemUseHandler, ResourceLocation>();

    public static synchronized void register(ResourceLocation id, ItemUseHandler handler) {
        if (REGISTRY.put(id, handler) != null) {
            throw new IllegalStateException("Handler with id " + String.valueOf(id) + " already registered!");
        }
        LOOKUP_REGISTRY.put(handler, id);
    }

    public static ItemUseHandler get(ResourceLocation id) {
        ItemUseHandler handler = REGISTRY.get(id);
        if (handler == null) {
            throw new IllegalStateException("No such handler " + String.valueOf(id) + " registered!");
        }
        return handler;
    }

    public static ResourceLocation getId(ItemUseHandler handler) {
        return LOOKUP_REGISTRY.get(handler);
    }

    public static Collection<ItemUseHandler> getAll() {
        return REGISTRY.values();
    }

    public static void initBuiltin() {
        ItemUseRegistry.register(ImprovedMobs.modRes("bow"), new BowHandler());
        ItemUseRegistry.register(ImprovedMobs.modRes("crossbow"), new CrossbowHandler());
        ItemUseRegistry.register(ImprovedMobs.modRes("enchanted_book"), new EnchantedBookHandler());
        ItemUseRegistry.register(ImprovedMobs.modRes("ender_pearl"), new EnderpearlHandler());
        ItemUseRegistry.register(ImprovedMobs.modRes("fishing_rod"), new FishingRodHandler());
        ItemUseRegistry.register(ImprovedMobs.modRes("flint_and_steel"), new FlintAndSteelHandler());
        ItemUseRegistry.register(ImprovedMobs.modRes("lava_bucket"), new LavaBucketHandler());
        ItemUseRegistry.register(ImprovedMobs.modRes("shield"), new ShieldHandler());
        ItemUseRegistry.register(ImprovedMobs.modRes("snowball"), new SimpleProjectileHandler(item -> item == Items.SNOWBALL, e -> 25, entity -> {
            Snowball ball = new Snowball(entity.level(), entity);
            ball.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot(), 0.0f, 1.5f, 1.0f);
            return ball;
        }, () -> SoundEvents.SNOWBALL_THROW));
        ItemUseRegistry.register(ImprovedMobs.modRes("potion"), new ThrowablePotionHandler());
        ItemUseRegistry.register(ImprovedMobs.modRes("tnt"), new TntHandler());
        ItemUseRegistry.register(ImprovedMobs.modRes("triden"), new TridentHandler());
    }
}

