/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.item.impl;

import io.github.flemmli97.improvedmobs.api.item.ItemUseHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LavaBucketHandler
implements ItemUseHandler {
    public static boolean tryPlaceLava(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        boolean flag = !state.isSolid();
        boolean flag1 = state.canBeReplaced();
        if (!state.getFluidState().isEmpty()) {
            return false;
        }
        if (!(state.isAir() || flag || flag1)) {
            return false;
        }
        if (!level.isClientSide && (flag || flag1) && !state.liquid()) {
            level.destroyBlock(pos, true);
        }
        level.playSound(null, pos, SoundEvents.BUCKET_EMPTY_LAVA, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.setBlock(pos, (BlockState)Blocks.LAVA.defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(1)), 11);
        return true;
    }

    @Override
    public void use(LivingEntity entity, LivingEntity target, InteractionHand hand) {
        double dis = entity.position().distanceToSqr(target.position());
        if (dis < 64.0 && LavaBucketHandler.tryPlaceLava(entity.level(), BlockPos.containing((double)(target.getX() - 2.0 + (double)entity.level().random.nextInt(4)), (double)(target.getY() - 1.0 + (double)entity.level().random.nextInt(2)), (double)(target.getZ() - 2.0 + (double)entity.level().random.nextInt(4))))) {
            entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 240, 1, true, false));
        }
    }

    @Override
    public ItemUseHandler.PreferredHand preferredHand() {
        return ItemUseHandler.PreferredHand.ANY;
    }

    @Override
    public int cooldown(LivingEntity entity) {
        return 80 + entity.getRandom().nextInt(20);
    }

    @Override
    public boolean matches(Item item) {
        return item == Items.LAVA_BUCKET;
    }
}

