/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.difficulty.DifficultyData;
import io.github.flemmli97.improvedmobs.common.difficulty.PlayerDifficulty;
import io.github.flemmli97.improvedmobs.common.network.PacketHandler;
import io.github.flemmli97.improvedmobs.common.registry.ImprovedMobsAttachments;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import io.github.flemmli97.tenshilib.loader.registry.AttachmentRegister;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ImprovedMobsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"improvedmobs").executes(ImprovedMobsCommand::getDifficulty)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"difficulty").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"player").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.literal((String)"set").then(Commands.argument((String)"val", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ImprovedMobsCommand::setDifficultyPlayer)))).then(Commands.literal((String)"add").then(Commands.argument((String)"val", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ImprovedMobsCommand::addDifficultyPlayer)))))).then(Commands.literal((String)"set").then(Commands.argument((String)"val", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ImprovedMobsCommand::setDifficulty)))).then(Commands.literal((String)"add").then(Commands.argument((String)"val", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ImprovedMobsCommand::addDifficulty)))).then(((LiteralArgumentBuilder)Commands.literal((String)"pause").then(Commands.literal((String)"player").then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).executes(src -> ImprovedMobsCommand.pauseDifficulty((CommandContext<CommandSourceStack>)src, GameProfileArgument.getGameProfiles((CommandContext)src, (String)"players"), true))))).executes(src -> ImprovedMobsCommand.pauseDifficulty((CommandContext<CommandSourceStack>)src, null, true)))).then(((LiteralArgumentBuilder)Commands.literal((String)"unpause").then(Commands.literal((String)"player").then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).executes(src -> ImprovedMobsCommand.pauseDifficulty((CommandContext<CommandSourceStack>)src, GameProfileArgument.getGameProfiles((CommandContext)src, (String)"players"), false))))).executes(src -> ImprovedMobsCommand.pauseDifficulty((CommandContext<CommandSourceStack>)src, null, false)))).then(Commands.literal((String)"simulate").then(((RequiredArgumentBuilder)Commands.argument((String)"steps", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.literal((String)"player").then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).executes(src -> ImprovedMobsCommand.simulateDifficulty((CommandContext<CommandSourceStack>)src, GameProfileArgument.getGameProfiles((CommandContext)src, (String)"players"), IntegerArgumentType.getInteger((CommandContext)src, (String)"steps")))))).executes(src -> ImprovedMobsCommand.simulateDifficulty((CommandContext<CommandSourceStack>)src, null, IntegerArgumentType.getInteger((CommandContext)src, (String)"steps")))))));
    }

    private static int setDifficulty(CommandContext<CommandSourceStack> src) {
        DifficultyData data = DifficultyData.get(((CommandSourceStack)src.getSource()).getServer());
        data.setDifficulty(DoubleArgumentType.getDouble(src, (String)"val"), ((CommandSourceStack)src.getSource()).getServer());
        ((CommandSourceStack)src.getSource()).sendSuccess(() -> Component.literal((String)("Difficulty set to " + data.getDifficulty())).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
        return 1;
    }

    private static int addDifficulty(CommandContext<CommandSourceStack> src) {
        DifficultyData data = DifficultyData.get(((CommandSourceStack)src.getSource()).getServer());
        data.addDifficulty(DoubleArgumentType.getDouble(src, (String)"val"), ((CommandSourceStack)src.getSource()).getServer());
        ((CommandSourceStack)src.getSource()).sendSuccess(() -> Component.literal((String)("Difficulty set to " + data.getDifficulty())).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
        return 1;
    }

    private static int setDifficultyPlayer(CommandContext<CommandSourceStack> src) throws CommandSyntaxException {
        Collection profs = GameProfileArgument.getGameProfiles(src, (String)"players");
        MinecraftServer server = ((CommandSourceStack)src.getSource()).getServer();
        for (GameProfile prof : profs) {
            ServerPlayer player = server.getPlayerList().getPlayer(prof.getId());
            PlayerDifficulty data = (PlayerDifficulty)AttachmentRegister.INSTANCE.getAttachment((Entity)player, ImprovedMobsAttachments.PLAYER_DIFFICULTY);
            data.setDifficultyLevel(DoubleArgumentType.getDouble(src, (String)"val"));
            CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createDifficultyPacket(DifficultyData.get(server), player), player);
            ((CommandSourceStack)src.getSource()).sendSuccess(() -> Component.literal((String)("Difficulty for " + prof.getName() + " set to " + data.getDifficultyLevel())).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
        }
        return profs.size();
    }

    private static int addDifficultyPlayer(CommandContext<CommandSourceStack> src) throws CommandSyntaxException {
        Collection profs = GameProfileArgument.getGameProfiles(src, (String)"players");
        MinecraftServer server = ((CommandSourceStack)src.getSource()).getServer();
        for (GameProfile prof : profs) {
            ServerPlayer player = server.getPlayerList().getPlayer(prof.getId());
            PlayerDifficulty data = (PlayerDifficulty)AttachmentRegister.INSTANCE.getAttachment((Entity)player, ImprovedMobsAttachments.PLAYER_DIFFICULTY);
            data.setDifficultyLevel(data.getDifficultyLevel() + DoubleArgumentType.getDouble(src, (String)"val"));
            CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createDifficultyPacket(DifficultyData.get(server), player), player);
            ((CommandSourceStack)src.getSource()).sendSuccess(() -> Component.literal((String)("Difficulty for " + prof.getName() + " set to " + data.getDifficultyLevel())).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
        }
        return profs.size();
    }

    private static int getDifficulty(CommandContext<CommandSourceStack> src) throws CommandSyntaxException {
        double diff;
        if (Config.CommonConfig.difficultyType == Config.DifficultyType.GLOBAL) {
            diff = DifficultyData.get(((CommandSourceStack)src.getSource()).getServer()).getDifficulty();
        } else {
            ServerPlayer player = ((CommandSourceStack)src.getSource()).getPlayerOrException();
            diff = ((PlayerDifficulty)AttachmentRegister.INSTANCE.getAttachment((Entity)player, ImprovedMobsAttachments.PLAYER_DIFFICULTY)).getDifficultyLevel();
        }
        ((CommandSourceStack)src.getSource()).sendSuccess(() -> Component.literal((String)("Difficulty: " + diff)).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
        return 1;
    }

    private static int pauseDifficulty(CommandContext<CommandSourceStack> src, Collection<GameProfile> profs, boolean pause) throws CommandSyntaxException {
        if (profs != null) {
            MinecraftServer server = ((CommandSourceStack)src.getSource()).getServer();
            for (GameProfile prof : profs) {
                ServerPlayer player = server.getPlayerList().getPlayer(prof.getId());
                PlayerDifficulty data = (PlayerDifficulty)AttachmentRegister.INSTANCE.getAttachment((Entity)player, ImprovedMobsAttachments.PLAYER_DIFFICULTY);
                data.setPaused(pause);
            }
            ((CommandSourceStack)src.getSource()).sendSuccess(() -> Component.literal((String)("Difficulty " + (pause ? "paused" : "unpaused") + " for given players")).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
            return profs.size();
        }
        DifficultyData data = DifficultyData.get(((CommandSourceStack)src.getSource()).getServer());
        data.setPaused(pause);
        ((CommandSourceStack)src.getSource()).sendSuccess(() -> Component.literal((String)("Difficulty " + (pause ? "paused" : "unpaused"))).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
        return 1;
    }

    private static int simulateDifficulty(CommandContext<CommandSourceStack> src, Collection<GameProfile> profs, int steps) {
        VariableMap vars = new VariableMap();
        if (profs != null) {
            MinecraftServer server = ((CommandSourceStack)src.getSource()).getServer();
            for (GameProfile prof : profs) {
                ServerPlayer player = server.getPlayerList().getPlayer(prof.getId());
                PlayerDifficulty data = (PlayerDifficulty)AttachmentRegister.INSTANCE.getAttachment((Entity)player, ImprovedMobsAttachments.PLAYER_DIFFICULTY);
                Config.apply(vars, (LivingEntity)player, 0.0);
                for (int i = steps; i > 0; --i) {
                    data.increaseCurrent(vars);
                }
                CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createDifficultyPacket(DifficultyData.get(server), player), player);
            }
            ((CommandSourceStack)src.getSource()).sendSuccess(() -> Component.literal((String)String.format("Simulated %s difficulty steps for given players", steps)).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
            return profs.size();
        }
        DifficultyData data = DifficultyData.get(((CommandSourceStack)src.getSource()).getServer());
        vars.clear();
        for (int i = steps; i > 0; --i) {
            data.increaseCurrent(vars);
        }
        ((CommandSourceStack)src.getSource()).sendSuccess(() -> Component.literal((String)String.format("Simulated %s difficulty steps globally. Now at %s", steps, data.getDifficulty())).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
        return 1;
    }
}

