/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.equipment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.config.equipment.OptionalItemStack;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class WeightedItemstack
implements Comparable<WeightedItemstack> {
    public static final Codec<WeightedItemstack> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)OptionalItemStack.CODEC.fieldOf("value").forGetter(d -> d.item), (App)Codec.INT.fieldOf("weight").forGetter(d -> d.weight), (App)Codec.FLOAT.fieldOf("quality").forGetter(d -> Float.valueOf(d.quality))).apply((Applicative)inst, WeightedItemstack::new));
    private final OptionalItemStack item;
    private final ItemStack stack;
    private final int weight;
    private final float quality;

    public WeightedItemstack(OptionalItemStack item, int itemWeight, float quality) {
        this.item = item;
        this.stack = item.asStack();
        this.weight = itemWeight;
        this.quality = quality;
    }

    public ItemStack getItem() {
        return this.stack.copy();
    }

    public int weight() {
        return this.weight;
    }

    public float quality() {
        return this.quality;
    }

    public int getWeight(double modifier) {
        return Math.max(this.weight + Mth.floor((double)(modifier * (double)this.quality)), 0);
    }

    public boolean valid() {
        return !this.stack.isEmpty() && (this.weight() > 0 || this.quality() > 0.0f) && this.isEnabled();
    }

    public boolean isEnabled() {
        if (Config.CommonConfig.equipmentModWhitelist) {
            return Config.CommonConfig.equipmentModBlacklist.contains(this.item.item().key().location().getNamespace());
        }
        return !Config.CommonConfig.equipmentModBlacklist.contains(this.item.item().key().location().getNamespace());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WeightedItemstack) {
            WeightedItemstack other = (WeightedItemstack)obj;
            return ItemStack.matches((ItemStack)this.stack, (ItemStack)other.stack);
        }
        return false;
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    @Override
    public int compareTo(WeightedItemstack o) {
        return this.item.item().getRegisteredName().compareTo(o.item.item().getRegisteredName());
    }

    public String toString() {
        return String.format("Item: %s; Weight: %s, Quality: %s", this.item.item().getRegisteredName(), this.weight, Float.valueOf(this.quality));
    }
}

