/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.values;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.common.config.values.ExpressionConfig;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DifficultyExpressionConfig {
    public static final Value DIFFICULTY_DEFAULT = new Value(0.0, "difficulty");
    private final List<Value> values = new ArrayList<Value>();

    public DifficultyExpressionConfig(UnresolvedValue ... values) {
        for (int i = 0; i < values.length; ++i) {
            UnresolvedValue value = values[i];
            UnresolvedValue next = i + 1 < values.length ? values[i + 1] : null;
            this.values.add(new Value(new DifficultyRange(value.minDifficulty, next == null ? Double.MAX_VALUE : next.minDifficulty), value.expression()));
        }
    }

    public Pair<Integer, Value> get(double difficulty, int index) {
        Value value;
        if (index >= 0 && index < this.values.size() && (value = this.values.get(index)).range().matches(difficulty)) {
            return Pair.of((Object)index, (Object)value);
        }
        for (int i = 0; i < this.values.size(); ++i) {
            int idx = Math.floorMod(i + index, this.values.size());
            Value value2 = this.values.get(idx);
            if (!value2.range().matches(difficulty)) continue;
            return Pair.of((Object)idx, (Object)value2);
        }
        return Pair.of((Object)-1, (Object)DIFFICULTY_DEFAULT);
    }

    public void read(List<String> config) {
        try {
            ArrayList<Value> list = new ArrayList<Value>();
            for (int i = 0; i < config.size(); ++i) {
                String[] parts = config.get(i).split(";");
                if (parts.length != 2) continue;
                String next = i + 1 < config.size() ? config.get(i + 1) : null;
                list.add(new Value(new DifficultyRange(parts[0], next), new ExpressionConfig(parts[1])));
            }
            this.values.clear();
            this.values.addAll(list);
        }
        catch (IllegalStateException e) {
            ImprovedMobs.LOGGER.error("Unable to parse expression from config: {}", config, (Object)e);
        }
    }

    public List<String> write() {
        ArrayList<String> list = new ArrayList<String>();
        this.values.forEach(v -> list.add(v.write()));
        return list;
    }

    public record Value(DifficultyRange range, ExpressionConfig expression) {
        public Value(double minDifficulty, String expression) {
            this(new DifficultyRange("" + minDifficulty, null), new ExpressionConfig(expression));
        }

        public String write() {
            return String.format("%s;%s", this.range.source, this.expression.write());
        }

        @Override
        public String toString() {
            return String.format("Value:[%s, %s]", this.range, this.expression.write());
        }
    }

    public static class DifficultyRange {
        private final String source;
        private final double start;
        private final double end;

        private DifficultyRange(String source, @Nullable String next) {
            this.source = source;
            if (source.contains("-")) {
                String[] vals = source.split("-");
                this.start = Double.parseDouble(vals[0]);
                this.end = Double.parseDouble(vals[1]);
            } else {
                String[] parts;
                this.start = Double.parseDouble(source);
                this.end = next == null ? Double.MAX_VALUE : ((parts = next.split(";")).length != 2 ? Double.MAX_VALUE : Double.parseDouble(parts[0].split("-")[0]));
            }
        }

        private DifficultyRange(double min, double max) {
            this.source = String.valueOf(min);
            this.start = min;
            this.end = max;
        }

        public boolean matches(double difficulty) {
            if (this.start < this.end) {
                return this.start <= difficulty && difficulty < this.end;
            }
            return difficulty <= this.start && difficulty > this.end;
        }

        public String toString() {
            return String.format("Range[%s, %s]", this.start, this.end);
        }
    }

    public record UnresolvedValue(double minDifficulty, ExpressionConfig expression) {
        public UnresolvedValue(double minDifficulty, String expression) {
            this(minDifficulty, new ExpressionConfig(expression));
        }
    }
}

