/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.values;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class TargetMapConfig {
    private final List<String> config = new ArrayList<String>();
    private boolean initialized;
    private final Map<EntityType<?>, Predicate<EntityType<?>>> map = new HashMap();

    @Nullable
    public Predicate<EntityType<?>> get(EntityType<?> type) {
        this.initialize();
        return this.map.get(type);
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        HashMap<EntityType, PredicateBuilder> builder = new HashMap<EntityType, PredicateBuilder>();
        for (String value : this.config) {
            String[] sub = value.replace(" ", "").split("-");
            Optional type2 = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)sub[0]));
            if (type2.isEmpty() || sub.length < 2) continue;
            if (sub[1].startsWith("#")) {
                TagKey tag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)sub[1].substring(1)));
                if (!BuiltInRegistries.ENTITY_TYPE.getTag(tag).isPresent()) continue;
                builder.computeIfAbsent((EntityType)type2.get(), key -> new PredicateBuilder()).appendTag(tag);
                continue;
            }
            EntityType target = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)sub[1])).orElse(null);
            if (target == null) {
                ImprovedMobs.LOGGER.error("Entity {} does not exist/is not registered", (Object)sub[1]);
                continue;
            }
            builder.computeIfAbsent((EntityType)type2.get(), key -> new PredicateBuilder()).appendType(target);
        }
        builder.forEach((type, pred) -> this.map.put((EntityType<?>)type, pred.build()));
    }

    public void read(List<String> config) {
        this.map.clear();
        this.config.clear();
        this.config.addAll(config);
        this.initialized = false;
    }

    public List<String> write() {
        return List.copyOf(this.config);
    }

    public static String[] use() {
        return new String[]{"List for of pairs containing which mobs auto target others.", "Syntax is <source-target> where", "  source: is the mob that should target something", "  target: the mob source should target. This can be either an entity or a tag", "Examples: ", "minecraft:zombie-minecraft:skeleton makes all zombies target skeletons", "minecraft:zombie-#minecraft:raiders makes all zombies target raid entities"};
    }

    private static class PredicateBuilder {
        private final List<EntityType<?>> direct = new ArrayList();
        private final List<TagKey<EntityType<?>>> tags = new ArrayList();

        private PredicateBuilder() {
        }

        public void appendType(EntityType<?> type) {
            this.direct.add(type);
        }

        public void appendTag(TagKey<EntityType<?>> tag) {
            this.tags.add(tag);
        }

        public Predicate<EntityType<?>> build() {
            ImmutableSet direct = ImmutableSet.copyOf(this.direct);
            ImmutableList tags = ImmutableList.copyOf(this.tags);
            return arg_0 -> PredicateBuilder.lambda$build$0((Set)direct, (List)tags, arg_0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static /* synthetic */ boolean lambda$build$0(Set direct, List tags, EntityType type) {
            if (direct.contains(type)) return true;
            if (!tags.stream().anyMatch(arg_0 -> ((EntityType)type).is(arg_0))) return false;
            return true;
        }
    }
}

