/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.entities;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.common.entities.RiddenSummonEntity;
import io.github.flemmli97.improvedmobs.common.entities.ai.pathfinding.WaterNavigation;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class AquaticSummonEntity
extends RiddenSummonEntity {
    public static final ResourceLocation SUMMONED_AQUATIC_ID = ImprovedMobs.modRes("aquatic_entity");
    private static final EntityDataAccessor<Boolean> DATA_ID_MOVING = SynchedEntityData.defineId(AquaticSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private Vec3 leapDir;
    private int leapTick;

    public AquaticSummonEntity(Level level) {
        super((EntityType<? extends Mob>)EntityType.GUARDIAN, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new AquaticMoveControl(this);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_MOVING, (Object)false);
    }

    public boolean isMoving() {
        return (Boolean)this.entityData.get(DATA_ID_MOVING);
    }

    protected void setMoving(boolean moving) {
        this.entityData.set(DATA_ID_MOVING, (Object)moving);
    }

    protected PathNavigation createNavigation(Level level) {
        return new WaterNavigation(this, level);
    }

    public void aiStep() {
        super.aiStep();
        --this.leapTick;
        if (this.leapTick < 0 || this.onGround()) {
            this.leapDir = null;
        }
        if (this.isInWaterOrBubble()) {
            this.setAirSupply(300);
        }
    }

    public int getMaxHeadXRot() {
        return 180;
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(0.1f, travelVector);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.85));
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (!this.isMoving() && this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            if (this.leapDir != null) {
                this.move(MoverType.SELF, this.leapDir);
            }
            super.travel(travelVector);
        }
    }

    @Override
    public ResourceLocation serverSideID() {
        return SUMMONED_AQUATIC_ID;
    }

    public boolean dismountsUnderwater() {
        return false;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.GUARDIAN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.GUARDIAN_DEATH;
    }

    public float getVoicePitch() {
        return super.getVoicePitch() * 0.8f;
    }

    public void setLeapDir(Vec3 dir) {
        this.leapDir = dir;
        this.leapTick = 20;
    }

    protected static class AquaticMoveControl
    extends MoveControl {
        private final AquaticSummonEntity mount;

        public AquaticMoveControl(AquaticSummonEntity mob) {
            super((Mob)mob);
            this.mount = mob;
        }

        public void tick() {
            if (this.operation != MoveControl.Operation.MOVE_TO || this.mount.getNavigation().isDone()) {
                this.mount.setSpeed(0.0f);
                this.mount.setMoving(false);
                return;
            }
            Vec3 dir = new Vec3(this.wantedX - this.mount.getX(), this.wantedY - this.mount.getY(), this.wantedZ - this.mount.getZ());
            double len = dir.length();
            double e = dir.x / len;
            double f = dir.y / len;
            double g = dir.z / len;
            float h = (float)(Mth.atan2((double)dir.z, (double)dir.x) * 57.2957763671875) - 90.0f;
            this.mount.setYRot(this.rotlerp(this.mount.getYRot(), h, 90.0f));
            this.mount.yBodyRot = this.mount.getYRot();
            float i = (float)(this.speedModifier * this.mount.getAttributeValue(Attributes.MOVEMENT_SPEED));
            float j = Mth.lerp((float)0.125f, (float)this.mount.getSpeed(), (float)i);
            this.mount.setSpeed(j);
            double k = Math.sin((double)(this.mount.tickCount + this.mount.getId()) * 0.5) * 0.05;
            double l = Math.cos(this.mount.getYRot() * ((float)Math.PI / 180));
            double m = Math.sin(this.mount.getYRot() * ((float)Math.PI / 180));
            double n = Math.sin((double)(this.mount.tickCount + this.mount.getId()) * 0.75) * 0.05;
            this.mount.setDeltaMovement(this.mount.getDeltaMovement().add(k * l * 0.8, n * (m + l) * 0.15 + (double)j * f * 0.1, k * m * 0.8));
            LookControl lookControl = this.mount.getLookControl();
            double o = this.mount.getX() + e * 2.0;
            double p = this.mount.getEyeY() + f / len;
            double q = this.mount.getZ() + g * 2.0;
            double r = lookControl.getWantedX();
            double s = lookControl.getWantedY();
            double t = lookControl.getWantedZ();
            if (!lookControl.isLookingAtTarget()) {
                r = o;
                s = p;
                t = q;
            }
            this.mount.getLookControl().setLookAt(Mth.lerp((double)0.125, (double)r, (double)o), Mth.lerp((double)0.125, (double)s, (double)p), Mth.lerp((double)0.125, (double)t, (double)q), 10.0f, 40.0f);
            this.mount.setMoving(true);
        }
    }
}

