/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.entities;

import com.google.common.collect.Iterables;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class RiddenSummonEntity
extends Mob {
    private boolean clearedAI;
    private Entity scheduledRide;
    private boolean scheduledDismount;

    public RiddenSummonEntity(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
        if (!level.isClientSide) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(5.0);
        }
    }

    public void scheduledRide(Entity passenger) {
        this.scheduledRide = passenger;
    }

    public void scheduledDismount() {
        this.scheduledDismount = true;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        return spawnData;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.getPassengers().contains(source.getEntity())) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean doHurtTarget(Entity entity) {
        return false;
    }

    public boolean canBeSeenAsEnemy() {
        return false;
    }

    public boolean hasEffect(Holder<MobEffect> potion) {
        return false;
    }

    @Nullable
    public MobEffectInstance getEffect(Holder<MobEffect> potion) {
        return null;
    }

    public boolean addEffect(MobEffectInstance effectInstance, @Nullable Entity entity) {
        return false;
    }

    public boolean canBeAffected(MobEffectInstance potioneffect) {
        return false;
    }

    public void forceAddEffect(MobEffectInstance mobEffectInstance, @Nullable Entity entity) {
    }

    protected void dropAllDeathLoot(ServerLevel level, DamageSource damageSource) {
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
    }

    public SlotAccess getSlot(int slot) {
        return SlotAccess.NULL;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        Entity e;
        EntityDimensions dimensions = this.originDimension(pose);
        if (this.isVehicle() && (e = this.getFirstPassenger()) != null) {
            EntityDimensions otherDim = e.getDimensions(e.getPose());
            float rideOffsetY = (float)this.getPassengerAttachmentPoint(e, dimensions, 1.0f).y();
            return EntityDimensions.scalable((float)Math.max(dimensions.width(), otherDim.width()), (float)Math.max(dimensions.height(), otherDim.height() + rideOffsetY));
        }
        return dimensions;
    }

    protected EntityDimensions originDimension(Pose pose) {
        return this.getType().getDimensions();
    }

    public static AABB riddenAABB(AABB thisAABB, AABB other) {
        double d = Math.min(thisAABB.minX, other.minX);
        double e = thisAABB.minY;
        double f = Math.min(thisAABB.minZ, other.minZ);
        double g = Math.max(thisAABB.maxX, other.maxX);
        double h = Math.max(thisAABB.maxY, other.maxY);
        double i = Math.max(thisAABB.maxZ, other.maxZ);
        return new AABB(d, e, f, g, h, i);
    }

    public Iterable<ItemStack> getAllSlots() {
        return Iterables.concat((Iterable[])new Iterable[0]);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (!this.clearedAI) {
                this.clearedAI = true;
                this.goalSelector.getAvailableGoals().forEach(WrappedGoal::stop);
                this.removeFreeWill();
            }
            if (this.scheduledRide != null) {
                this.scheduledRide.startRiding((Entity)this);
                this.scheduledRide = null;
            }
            if (this.scheduledDismount && this.getFirstPassenger() != null) {
                this.getFirstPassenger().stopRiding();
                this.scheduledDismount = false;
            }
            if (!this.isVehicle()) {
                this.remove(Entity.RemovalReason.KILLED);
            }
        }
    }

    protected Component getTypeName() {
        return this.getType().getDescription();
    }

    protected void addPassenger(Entity passenger) {
        super.addPassenger(passenger);
        this.refreshDimensions();
    }

    public CompoundTag saveWithoutId(CompoundTag compound) {
        CompoundTag tag = super.saveWithoutId(compound);
        tag.getCompound("IMFlags").putString("ServerSideEntityID", this.serverSideID().toString());
        return tag;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return BuiltInLootTables.EMPTY;
    }

    public abstract ResourceLocation serverSideID();

    public boolean doesntCollideWithRidden(Entity rider) {
        return this.level().noCollision((Entity)this, RiddenSummonEntity.riddenAABB(this.getBoundingBox(), rider.getBoundingBox()));
    }
}

