/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.entities.ai;

import io.github.flemmli97.improvedmobs.common.entities.FlyingSummonEntity;
import io.github.flemmli97.improvedmobs.common.entities.RiddenSummonEntity;
import io.github.flemmli97.improvedmobs.common.entities.ai.pathfinding.FlyNodeEvalRider;
import io.github.flemmli97.improvedmobs.mixin.MobEntityMixin;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import org.jetbrains.annotations.Nullable;

public class FlyRidingGoal
extends Goal {
    protected final Mob living;
    private int idle;
    private int pathCheckWait;
    private int flyDelay;
    private int targetDelay;
    private boolean start;
    private final PathNavigation flyer;

    public FlyRidingGoal(Mob living) {
        this.living = living;
        this.flyer = new FlyingPathNavigation(this, living, living.level()){

            protected PathFinder createPathFinder(int maxVisitedNodes) {
                this.nodeEvaluator = new FlyNodeEvalRider();
                this.nodeEvaluator.setCanPassDoors(true);
                return new PathFinder(this.nodeEvaluator, maxVisitedNodes);
            }

            @Nullable
            protected Path createPath(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
                return super.createPath(targets, regionOffset, offsetUpward, accuracy, followRange - 2.0f);
            }

            public boolean isStableDestination(BlockPos blockPos) {
                return true;
            }
        };
    }

    public boolean canUse() {
        if (this.living.getVehicle() instanceof FlyingSummonEntity) {
            return true;
        }
        if (this.isFlying()) {
            return false;
        }
        LivingEntity target = this.living.getTarget();
        if (target == null || !target.isAlive() || !this.living.isWithinRestriction(target.blockPosition())) {
            this.targetDelay = 0;
        } else if (!this.living.isPassenger() && ++this.targetDelay > 100 && --this.pathCheckWait <= 0) {
            this.pathCheckWait = 30;
            if (this.checkFlying()) {
                this.targetDelay = 0;
                this.idle = 0;
                return true;
            }
        }
        return false;
    }

    private boolean isFlying() {
        return this.living.getNavigation() instanceof FlyingPathNavigation;
    }

    public boolean canContinueToUse() {
        if (this.living.getVehicle() instanceof FlyingSummonEntity) {
            this.idle = this.living.getTarget() == null ? ++this.idle : 0;
            return this.idle < 100;
        }
        return false;
    }

    public void stop() {
        Entity entity = this.living.getVehicle();
        if (entity instanceof RiddenSummonEntity) {
            RiddenSummonEntity mount = (RiddenSummonEntity)entity;
            mount.scheduledDismount();
        }
        this.living.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 200, 1));
        this.idle = 0;
        this.targetDelay = 0;
    }

    public void start() {
        this.start = true;
    }

    public void tick() {
        FlyingSummonEntity summon;
        Entity entity;
        if (this.start) {
            if (!this.living.isPassenger()) {
                FlyingSummonEntity summon2 = new FlyingSummonEntity(this.living.level());
                BlockPos pos = this.living.blockPosition();
                summon2.moveTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, this.living.getYRot(), this.living.getXRot());
                if (summon2.doesntCollideWithRidden((Entity)this.living)) {
                    this.living.level().addFreshEntity((Entity)summon2);
                    summon2.scheduledRide((Entity)this.living);
                    this.flyDelay = 0;
                }
            }
            this.start = false;
        }
        if (!((entity = this.living.getVehicle()) instanceof FlyingSummonEntity) || !(summon = (FlyingSummonEntity)entity).isAlive()) {
            return;
        }
        if (++this.flyDelay >= 40 && this.isOnLand(entity)) {
            summon.scheduledDismount();
        }
    }

    private boolean checkFlying() {
        if (this.living.isUnderWater()) {
            return false;
        }
        if (this.living.isNoGravity() || !this.living.onGround()) {
            return false;
        }
        Path path = this.living.getNavigation().getPath();
        if (path == null || this.living.getNavigation().isStuck() || path.isDone() || !path.canReach()) {
            Path ground = this.living.getNavigation().createPath((Entity)this.living.getTarget(), 1);
            if (ground != null && ground.canReach()) {
                return false;
            }
            Path flyer = this.flyer.createPath((Entity)this.living.getTarget(), 1);
            double dist = ground == null || ground.getEndNode() == null ? (double)this.living.blockPosition().distManhattan((Vec3i)this.living.getTarget().blockPosition()) : (double)ground.getEndNode().distanceManhattan(this.living.getTarget().blockPosition());
            return flyer != null && (flyer.canReach() || (double)flyer.getDistToTarget() < dist);
        }
        return false;
    }

    private boolean isOnLand(Entity riding) {
        if (this.living.getNavigation().isDone() && riding.level().getBlockState(riding.blockPosition().below()).isSolid()) {
            return true;
        }
        LivingEntity target = this.living.getTarget();
        PathNavigation trueNav = ((MobEntityMixin)this.living).getTrueNavigator();
        if (target != null) {
            if (BehaviorUtils.isWithinAttackRange((Mob)this.living, (LivingEntity)target, (int)0)) {
                return riding.level().getBlockState(riding.blockPosition().below()).isSolid();
            }
            if (--this.pathCheckWait > 0) {
                return false;
            }
            Path ground = trueNav.createPath((Entity)target, 1);
            this.pathCheckWait = 25;
            if (ground != null && ground.canReach()) {
                return riding.level().getBlockState(riding.blockPosition().below()).isSolid();
            }
        }
        return false;
    }
}

