/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.entities.ai;

import io.github.flemmli97.improvedmobs.api.datapack.ItemUseLookupManager;
import io.github.flemmli97.improvedmobs.api.item.ItemUseHandler;
import io.github.flemmli97.improvedmobs.api.item.MoveHandler;
import io.github.flemmli97.improvedmobs.common.utils.EntityFlags;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import org.apache.commons.lang3.tuple.Pair;

public class ItemUseGoal
extends Goal {
    private final Mob living;
    private int cooldown = -1;
    private int attackDelay = -1;
    private ItemUseHandler ai;
    private InteractionHand hand;
    private MoveHandler moveHandler;
    private ItemStack stackMain;
    private ItemStack stackOff;

    public ItemUseGoal(Mob entity) {
        this.living = entity;
    }

    public boolean canUse() {
        LivingEntity target = this.living.getTarget();
        if (target == null || !target.isAlive() || target.getRandom().nextInt(10) != 0) {
            return false;
        }
        this.calculateAi();
        return this.ai != null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canContinueToUse() {
        LivingEntity target = this.living.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (this.stackMain != this.living.getMainHandItem() || this.stackOff != this.living.getOffhandItem()) {
            this.calculateAi();
        }
        return this.ai != null;
    }

    private void calculateAi() {
        Pair<ItemUseHandler, InteractionHand> pair = ItemUseLookupManager.getInstance().get(this.living);
        this.ai = (ItemUseHandler)pair.getKey();
        this.hand = (InteractionHand)pair.getValue();
        if (this.ai != null) {
            this.moveHandler = this.ai.movementType() != null ? this.ai.movementType().apply(this.living) : null;
            this.setFlags(this.ai.movementType() != null ? EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK) : EnumSet.noneOf(Goal.Flag.class));
        }
        this.stackMain = this.living.getMainHandItem();
        this.stackOff = this.living.getOffhandItem();
    }

    public void stop() {
        this.cooldown = -1;
        this.attackDelay = -1;
        this.living.stopUsingItem();
        this.ai = null;
        this.stackMain = null;
        this.stackOff = null;
        this.setFlags(EnumSet.noneOf(Goal.Flag.class));
    }

    public void tick() {
        if (EntityFlags.get((Entity)this.living).isShieldDisabled() && this.living.getItemInHand(this.hand).getUseAnimation() == UseAnim.BLOCK) {
            return;
        }
        LivingEntity target = this.living.getTarget();
        if (target != null) {
            boolean canSee = this.living.getSensing().hasLineOfSight((Entity)target);
            if (this.moveHandler != null) {
                this.moveHandler.move(target, canSee);
            }
            if (this.attackDelay < 0 && --this.cooldown < 0 && canSee) {
                this.ai.start((LivingEntity)this.living, target, this.hand);
                this.attackDelay = this.ai.attackDelay((LivingEntity)this.living, this.living.getItemInHand(this.hand));
            }
            if (--this.attackDelay == -1) {
                this.ai.use((LivingEntity)this.living, target, this.hand);
                this.cooldown = this.ai.cooldown((LivingEntity)this.living);
            } else if (this.attackDelay > 0) {
                this.ai.onPrepare((LivingEntity)this.living, target, this.hand);
            }
        }
    }
}

