/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.entities.ai.util;

import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AIUtils {
    public static void setHeadingToPosition(ThrowableProjectile e, double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 dir = new Vec3(x - e.getX(), y - e.getY(), z - e.getZ()).scale((double)(1.0f / velocity));
        e.shoot(dir.x, dir.y, dir.z, velocity, inaccuracy);
    }

    public static void applyPotion(ThrownPotion entity, Iterable<MobEffectInstance> effects, @Nullable Entity p_213888_2_) {
        AABB axisalignedbb = entity.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List list = entity.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb);
        for (LivingEntity livingentity : list) {
            double d0;
            if (entity.getOwner() instanceof Mob && !livingentity.equals((Object)((Mob)entity.getOwner()).getTarget()) || !livingentity.isAffectedByPotions() || !((d0 = entity.distanceToSqr((Entity)livingentity)) < 16.0)) continue;
            double d1 = 1.0 - Math.sqrt(d0) / 4.0;
            if (livingentity == p_213888_2_) {
                d1 = 1.0;
            }
            for (MobEffectInstance effectinstance : effects) {
                MobEffect effect = (MobEffect)effectinstance.getEffect().value();
                if (effect.isInstantenous()) {
                    effect.applyInstantenousEffect((Entity)entity, entity.getOwner(), livingentity, effectinstance.getAmplifier(), d1);
                    continue;
                }
                int i = (int)(d1 * (double)effectinstance.getDuration() + 0.5);
                if (i <= 20) continue;
                livingentity.addEffect(new MobEffectInstance(effectinstance.getEffect(), i, effectinstance.getAmplifier(), effectinstance.isAmbient(), effectinstance.isVisible()));
            }
        }
    }
}

