/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.utils;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.improvedmobs.common.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class BlockRestorationData
extends SavedData {
    private static final String ID = "ImprovedMobsRestoration";
    private static final SavedData.Factory<BlockRestorationData> FACTORY = new SavedData.Factory(BlockRestorationData::new, BlockRestorationData::new, DataFixTypes.LEVEL);
    private final Long2ObjectMap<Long2ObjectMap<SavedBlock>> toRestore = new Long2ObjectOpenHashMap();

    public BlockRestorationData() {
    }

    private BlockRestorationData(CompoundTag tag, HolderLookup.Provider provider) {
        this.load(tag);
    }

    public static BlockRestorationData get(ServerLevel level) {
        return (BlockRestorationData)level.getDataStorage().computeIfAbsent(FACTORY, ID);
    }

    public void restore(ServerLevel level, BlockState state, BlockPos pos, @Nullable Entity entity) {
        Long2ObjectMap chunk = (Long2ObjectMap)this.toRestore.computeIfAbsent(ChunkPos.asLong((BlockPos)pos), o -> new Long2ObjectOpenHashMap());
        SavedBlock current = (SavedBlock)chunk.get(pos.asLong());
        if (current != null) {
            current.toDrop.forEach(stack -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack));
        }
        BlockEntity blockEntity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        List drops = Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)entity, (ItemStack)ItemStack.EMPTY);
        chunk.put(pos.asLong(), (Object)new SavedBlock(state, level.getGameTime(), drops));
        this.setDirty();
    }

    public void tick(ServerLevel level) {
        LongArraySet toRemove = new LongArraySet();
        long time = level.getGameTime();
        boolean particle = time % 5L == 0L;
        this.toRestore.forEach((arg_0, arg_1) -> this.lambda$tick$4(level, time, particle, (LongSet)toRemove, arg_0, arg_1));
        toRemove.forEach(arg_0 -> this.toRestore.remove(arg_0));
    }

    public void load(CompoundTag data) {
        data.getAllKeys().forEach(chunk -> {
            Long2ObjectOpenHashMap blocksMap = new Long2ObjectOpenHashMap();
            ListTag blocks = data.getList(chunk, 10);
            blocks.forEach(arg_0 -> BlockRestorationData.lambda$load$6((Long2ObjectMap)blocksMap, arg_0));
            this.toRestore.put(Long.parseLong(chunk), (Object)blocksMap);
        });
    }

    public CompoundTag save(CompoundTag data, HolderLookup.Provider provider) {
        this.toRestore.forEach((chunk, blocks) -> {
            ListTag list = new ListTag();
            blocks.forEach((pos, d) -> {
                CompoundTag blockSave = new CompoundTag();
                blockSave.putLong("Pos", pos.longValue());
                blockSave.put("State", (Tag)BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)d.state).getOrThrow());
                blockSave.putLong("Time", d.time);
                ListTag stacks = new ListTag();
                d.toDrop.forEach(s -> stacks.add((Object)((Tag)ItemStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, s).getOrThrow())));
                blockSave.put("Drops", (Tag)stacks);
                list.add((Object)blockSave);
            });
            data.put(String.valueOf(chunk), (Tag)list);
        });
        return data;
    }

    private static /* synthetic */ void lambda$load$6(Long2ObjectMap blocksMap, Tag t) {
        CompoundTag blockSave = (CompoundTag)t;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        blockSave.getList("Drops", 10).forEach(st -> stacks.add((ItemStack)ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, st).getOrThrow()));
        blocksMap.put(blockSave.getLong("Pos"), (Object)new SavedBlock((BlockState)BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)blockSave.get("State")).getOrThrow(), blockSave.getLong("Time"), stacks));
    }

    private /* synthetic */ void lambda$tick$4(ServerLevel level, long time, boolean particle, LongSet toRemove, Long chunk, Long2ObjectMap data) {
        ChunkPos chunkPos = new ChunkPos(chunk.longValue());
        if (level.hasChunk(chunkPos.x, chunkPos.z)) {
            LongArraySet toRemoveBlocks = new LongArraySet();
            LevelChunk levelChunk = level.getChunk(chunkPos.x, chunkPos.z);
            data.forEach((arg_0, arg_1) -> BlockRestorationData.lambda$tick$3(levelChunk, time, level, (LongSet)toRemoveBlocks, particle, arg_0, arg_1));
            toRemoveBlocks.forEach(arg_0 -> ((Long2ObjectMap)data).remove(arg_0));
            if (data.isEmpty()) {
                toRemove.add(chunk.longValue());
            }
            if (!toRemoveBlocks.isEmpty()) {
                this.setDirty();
            }
        }
    }

    private static /* synthetic */ void lambda$tick$3(LevelChunk levelChunk, long time, ServerLevel level, LongSet toRemoveBlocks, boolean particle, Long packedPos, SavedBlock replace) {
        BlockPos pos = BlockPos.of((long)packedPos);
        BlockState current = levelChunk.getBlockState(pos);
        if (current.getBlock() == Blocks.AIR) {
            if (Math.abs(time - replace.time) > (long)Config.CommonConfig.restoreDelay) {
                level.setBlock(pos, replace.state, 3);
                toRemoveBlocks.add(packedPos.longValue());
            } else if (particle) {
                level.sendParticles((ParticleOptions)DustParticleOptions.REDSTONE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
            }
        } else {
            replace.toDrop.forEach(stack -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack));
            toRemoveBlocks.add(packedPos.longValue());
        }
    }

    public record SavedBlock(BlockState state, long time, List<ItemStack> toDrop) {
    }
}

