/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.neoforge.platform;

import io.github.flemmli97.improvedmobs.common.difficulty.DifficultyData;
import io.github.flemmli97.improvedmobs.common.network.PacketHandler;
import io.github.flemmli97.improvedmobs.common.network.S2CDiffcultyValue;
import io.github.flemmli97.improvedmobs.common.registry.ImprovedMobsAttachments;
import io.github.flemmli97.improvedmobs.common.utils.ContainerOpened;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.tenshilib.loader.registry.AttachmentRegister;
import java.nio.file.Path;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class CrossPlatformStuffImpl
implements CrossPlatformStuff {
    @Override
    public boolean canLoot(BlockEntity blockEntity) {
        IItemHandler cap = (IItemHandler)blockEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), null);
        if (cap == null) {
            return false;
        }
        ContainerOpened attachment = AttachmentRegister.INSTANCE.getOptionalAttachment(blockEntity, ImprovedMobsAttachments.HAS_BEEN_OPENED.get()).orElse(null);
        if (attachment != null) {
            return attachment.playerOpened();
        }
        return false;
    }

    @Override
    public ItemStack lootRandomItem(BlockEntity blockEntity, RandomSource rand) {
        IItemHandler cap = (IItemHandler)blockEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), null);
        if (cap != null) {
            ItemStack drop = cap.extractItem(rand.nextInt(cap.getSlots()), 1, false);
            for (int tries = 0; drop.isEmpty() && tries < 10; ++tries) {
                drop = cap.extractItem(rand.nextInt(cap.getSlots()), 1, false);
            }
            return drop;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean isClimbable(BlockState state, LivingEntity entity, BlockPos pos) {
        return state.isLadder((LevelReader)entity.level(), pos, entity);
    }

    @Override
    public SoundType blockSound(BlockState state, LivingEntity entity, BlockPos pos) {
        return state.getSoundType((LevelReader)entity.level(), pos, (Entity)entity);
    }

    @Override
    public void sendClientboundPacket(CustomPacketPayload payload, ServerPlayer player) {
        if (player.connection.hasChannel(payload)) {
            player.connection.send(payload);
        }
    }

    @Override
    public void sendDifficultyData(DifficultyData data, MinecraftServer server) {
        server.getPlayerList().getPlayers().forEach(player -> {
            if (player.connection.hasChannel(S2CDiffcultyValue.TYPE)) {
                player.connection.send((CustomPacketPayload)PacketHandler.createDifficultyPacket(data, player));
            }
        });
    }

    @Override
    public Path configDirPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public AbstractArrow customBowArrow(ItemStack weapon, ItemStack projectile, AbstractArrow def) {
        Item item = weapon.getItem();
        if (item instanceof BowItem) {
            BowItem bow = (BowItem)item;
            return bow.customArrow(def, projectile, weapon);
        }
        return def;
    }

    @Override
    public boolean canDisableShield(ItemStack attackingStack, ItemStack held, LivingEntity entity, LivingEntity attacker) {
        return attackingStack.canDisableShield(held, entity, attacker);
    }
}

