/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.numismaticws.mixin;

import com.glisco.numismaticoverhaul.ModComponents;
import com.glisco.numismaticoverhaul.NumismaticOverhaul;
import com.glisco.numismaticoverhaul.currency.Currency;
import com.glisco.numismaticoverhaul.currency.CurrencyComponent;
import com.glisco.numismaticoverhaul.currency.CurrencyConverter;
import com.glisco.numismaticoverhaul.item.CoinItem;
import com.glisco.numismaticoverhaul.item.MoneyBagComponent;
import com.glisco.numismaticoverhaul.item.NumismaticOverhaulItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.access.WaystoneValue;
import wraith.fwaystones.block.WaystoneBlockEntity;
import wraith.fwaystones.util.FWConfigModel;
import wraith.fwaystones.util.TeleportSources;
import wraith.fwaystones.util.Utils;

@Mixin(value={Utils.class})
public abstract class UtilsMixin {
    @Inject(method={"containsItem"}, at={@At(value="HEAD")}, cancellable=true)
    private static void addCoinsFromBagsAndPurse(class_1661 inventory, class_1792 item, int maxAmount, CallbackInfoReturnable<Boolean> cir) {
        if (!(item instanceof CoinItem)) {
            return;
        }
        CoinItem coinItem = (CoinItem)item;
        Currency currency = coinItem.currency;
        long itemValue = currency.getRawValue(1L);
        long total = 0L;
        for (class_1799 stack : inventory.field_7547) {
            if (stack.method_7909() == item) {
                total += (long)stack.method_7947();
                continue;
            }
            if (stack.method_7909() != NumismaticOverhaulItems.MONEY_BAG) continue;
            total += UtilsMixin.getCoinCountFromBag(stack, itemValue);
        }
        for (class_1799 stack : inventory.field_7544) {
            if (stack.method_7909() == item) {
                total += (long)stack.method_7947();
                continue;
            }
            if (stack.method_7909() != NumismaticOverhaulItems.MONEY_BAG) continue;
            total += UtilsMixin.getCoinCountFromBag(stack, itemValue);
        }
        for (class_1799 stack : inventory.field_7548) {
            if (stack.method_7909() == item) {
                total += (long)stack.method_7947();
                continue;
            }
            if (stack.method_7909() != NumismaticOverhaulItems.MONEY_BAG) continue;
            total += UtilsMixin.getCoinCountFromBag(stack, itemValue);
        }
        long purseValue = ((CurrencyComponent)ModComponents.CURRENCY.get((Object)inventory.field_7546)).getValue();
        cir.setReturnValue((Object)((total += purseValue / itemValue) >= (long)maxAmount ? 1 : 0));
    }

    @Inject(method={"removeItem"}, at={@At(value="HEAD")}, cancellable=true)
    private static void removeCoinsFromBagsAndPurse(class_1661 inventory, class_1792 item, int totalAmount, CallbackInfo ci) {
        long removed;
        class_1799 bagStack;
        int i;
        long amount;
        if (!(item instanceof CoinItem)) {
            return;
        }
        CoinItem coinItem = (CoinItem)item;
        Currency currency = coinItem.currency;
        long itemValue = currency.getRawValue(1L);
        long remaining = totalAmount;
        for (class_1799 stack : inventory.field_7547) {
            if (stack.method_7909() != item) continue;
            amount = stack.method_7947();
            stack.method_7934((int)Math.min(remaining, amount));
            if ((remaining -= amount) > 0L) continue;
            ci.cancel();
            return;
        }
        for (class_1799 stack : inventory.field_7544) {
            if (stack.method_7909() != item) continue;
            amount = stack.method_7947();
            stack.method_7934((int)Math.min(remaining, amount));
            if ((remaining -= amount) > 0L) continue;
            ci.cancel();
            return;
        }
        for (class_1799 stack : inventory.field_7548) {
            if (stack.method_7909() != item) continue;
            amount = stack.method_7947();
            stack.method_7934((int)Math.min(remaining, amount));
            if ((remaining -= amount) > 0L) continue;
            ci.cancel();
            return;
        }
        for (i = 0; i < inventory.field_7547.size(); ++i) {
            bagStack = (class_1799)inventory.field_7547.get(i);
            if (bagStack.method_7909() != NumismaticOverhaulItems.MONEY_BAG) continue;
            removed = UtilsMixin.removeFromBag(bagStack, itemValue, remaining);
            UtilsMixin.handleBagPostDeduction((List<class_1799>)inventory.field_7547, i, bagStack);
            if ((remaining -= removed) > 0L) continue;
            ci.cancel();
            return;
        }
        for (i = 0; i < inventory.field_7544.size(); ++i) {
            bagStack = (class_1799)inventory.field_7544.get(i);
            if (bagStack.method_7909() != NumismaticOverhaulItems.MONEY_BAG) continue;
            removed = UtilsMixin.removeFromBag(bagStack, itemValue, remaining);
            UtilsMixin.handleBagPostDeduction((List<class_1799>)inventory.field_7544, i, bagStack);
            if ((remaining -= removed) > 0L) continue;
            ci.cancel();
            return;
        }
        for (i = 0; i < inventory.field_7548.size(); ++i) {
            bagStack = (class_1799)inventory.field_7548.get(i);
            if (bagStack.method_7909() != NumismaticOverhaulItems.MONEY_BAG) continue;
            removed = UtilsMixin.removeFromBag(bagStack, itemValue, remaining);
            UtilsMixin.handleBagPostDeduction((List<class_1799>)inventory.field_7548, i, bagStack);
            if ((remaining -= removed) > 0L) continue;
            ci.cancel();
            return;
        }
        if (remaining > 0L) {
            long toDeduct = remaining * itemValue;
            ((CurrencyComponent)ModComponents.CURRENCY.get((Object)inventory.field_7546)).modify(-toDeduct);
        }
        ci.cancel();
    }

    @Inject(method={"canTeleport"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;increment(I)V")}, cancellable=true)
    private static void handleWaystoneInventoryCoinStack(class_1657 player, String hash, TeleportSources source, boolean takeCost, CallbackInfoReturnable<Boolean> cir) {
        if (!takeCost || player.method_37908().field_9236 || FabricWaystones.WAYSTONE_STORAGE == null) {
            return;
        }
        WaystoneValue waystone = FabricWaystones.WAYSTONE_STORAGE.getWaystoneData(hash);
        if (waystone == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"fwaystones.no_teleport.invalid_waystone"), true);
            cir.setReturnValue((Object)false);
            return;
        }
        WaystoneBlockEntity waystoneBE = waystone.getEntity();
        if (waystoneBE == null) {
            return;
        }
        FWConfigModel.CostType cost = FabricWaystones.CONFIG.teleportation_cost.cost_type();
        if (cost != FWConfigModel.CostType.ITEM) {
            return;
        }
        class_2960 itemId = Utils.getTeleportCostItem();
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
        if (!(item instanceof CoinItem)) {
            return;
        }
        int amount = Utils.getCost((class_243)player.method_19538(), (class_243)class_243.method_24953((class_2382)waystone.way_getPos()), (String)Utils.getDimensionName((class_1937)player.method_37908()), (String)waystone.getWorldName());
        if (!Utils.containsItem((class_1661)player.method_31548(), (class_1792)item, (int)amount)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"fwaystones.no_teleport.item"), true);
            cir.setReturnValue((Object)false);
            return;
        }
        Utils.removeItem((class_1661)player.method_31548(), (class_1792)item, (int)amount);
        ArrayList<class_1799> oldInventory = new ArrayList<class_1799>((Collection<class_1799>)waystoneBE.getInventory());
        int remaining = amount;
        boolean found = false;
        for (class_1799 stack : oldInventory) {
            int space;
            if (stack.method_7909() != item || (space = item.method_7882() - stack.method_7947()) <= 0) continue;
            int toAdd = Math.min(remaining, space);
            stack.method_7933(toAdd);
            found = true;
            if ((remaining -= toAdd) > 0) continue;
            break;
        }
        while (remaining > 0) {
            int toAdd = Math.min(remaining, item.method_7882());
            oldInventory.add(new class_1799((class_1935)item, toAdd));
            remaining -= toAdd;
        }
        waystoneBE.setInventory(oldInventory);
        cir.setReturnValue((Object)true);
    }

    @Unique
    private static long getCoinCountFromBag(class_1799 bag, long itemValue) {
        MoneyBagComponent component = (MoneyBagComponent)bag.method_57825(NumismaticOverhaul.MONEY_BAG_COMPONENT, (Object)MoneyBagComponent.of((long)0L));
        return component.value() / itemValue;
    }

    @Unique
    private static long removeFromBag(class_1799 bag, long itemValue, long maxRemove) {
        MoneyBagComponent component = (MoneyBagComponent)bag.method_57825(NumismaticOverhaul.MONEY_BAG_COMPONENT, (Object)MoneyBagComponent.of((long)0L));
        long bagValue = component.value();
        long maxEquiv = bagValue / itemValue;
        long removeEquiv = Math.min(maxRemove, maxEquiv);
        long deductRaw = removeEquiv * itemValue;
        long newValue = bagValue - deductRaw;
        bag.method_57379(NumismaticOverhaul.MONEY_BAG_COMPONENT, (Object)MoneyBagComponent.of((long)newValue));
        return removeEquiv;
    }

    @Unique
    private static void handleBagPostDeduction(List<class_1799> invList, int index, class_1799 bag) {
        boolean canBeCompacted;
        MoneyBagComponent component = (MoneyBagComponent)bag.method_57825(NumismaticOverhaul.MONEY_BAG_COMPONENT, (Object)MoneyBagComponent.of((long)0L));
        long newValue = component.value();
        if (newValue <= 0L) {
            invList.set(index, class_1799.field_8037);
            return;
        }
        long[] values = new long[]{component.bronze(), component.silver(), component.gold()};
        boolean bl = canBeCompacted = component.bronze() < 100L && component.silver() < 100L && component.gold() < 100L;
        if (canBeCompacted && CurrencyConverter.getAsValidStacks((long[])values).size() == 1) {
            class_1799 newStack = (class_1799)CurrencyConverter.getAsValidStacks((long[])values).getFirst();
            invList.set(index, newStack);
        }
    }
}

