/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.tfc_textile.datagen;

import java.util.concurrent.CompletableFuture;
import net.atobaazul.tfc_textile.datagen.providers.TextileBlockTagProvider;
import net.atobaazul.tfc_textile.datagen.providers.TextileGlobalLootModifierProvider;
import net.atobaazul.tfc_textile.datagen.providers.TextileItemModelProvider;
import net.atobaazul.tfc_textile.datagen.providers.TextileItemTagsProvider;
import net.atobaazul.tfc_textile.datagen.providers.TextileLangProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber
public class TextileDatagenProviders {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        TextileBlockTagProvider blockTagProvider = (TextileBlockTagProvider)generator.addProvider(event.includeServer(), (DataProvider)new TextileBlockTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TextileItemTagsProvider(packOutput, lookupProvider, blockTagProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new TextileItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new TextileLangProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new TextileGlobalLootModifierProvider(packOutput, lookupProvider));
    }
}

