/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.tfc_textile.datagen.providers;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.atobaazul.tfc_textile.common.item.TextileItemTags;
import net.atobaazul.tfc_textile.registries.TextileItems;
import net.dries007.tfc.common.items.HideItemType;
import net.dries007.tfc.common.items.TFCItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class TextileItemTagsProvider
extends ItemTagsProvider {
    private static final TagKey<Item> CLOTHES_HAT = TextileItemTagsProvider.ambientalTag("clothes_hat");
    private static final TagKey<Item> CLOTHES_PANTS = TextileItemTagsProvider.ambientalTag("clothes_pants");
    private static final TagKey<Item> CLOTHES_SOCKS = TextileItemTagsProvider.ambientalTag("clothes_socks");
    private static final TagKey<Item> CLOTHES_TORSO = TextileItemTagsProvider.ambientalTag("clothes_torso");
    private static final TagKey<Item> CURIOS_HAT = TextileItemTagsProvider.curiosTag("clothes_hat");
    private static final TagKey<Item> CURIOS_PANTS = TextileItemTagsProvider.curiosTag("clothes_pants");
    private static final TagKey<Item> CURIOS_SOCKS = TextileItemTagsProvider.curiosTag("clothes_socks");
    private static final TagKey<Item> CURIOS_TORSO = TextileItemTagsProvider.curiosTag("clothes_torso");

    public TextileItemTagsProvider(@NotNull PackOutput output, @NotNull CompletableFuture<HolderLookup.Provider> lookupProvider, @NotNull CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTags, "tfc_textile_legacy", existingFileHelper);
    }

    private static TagKey<Item> ambientalTag(String tag) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)tag));
    }

    private static TagKey<Item> curiosTag(String tag) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)tag));
    }

    protected void addTags(HolderLookup.Provider provider) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender clothesHat = this.tag(CLOTHES_HAT).replace(false);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender clothesPants = this.tag(CLOTHES_PANTS).replace(false);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender clothesSocks = this.tag(CLOTHES_SOCKS).replace(false);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender clothesTorso = this.tag(CLOTHES_TORSO).replace(false);
        ArrayList<IntrinsicHolderTagsProvider.IntrinsicTagAppender> clothingTags = new ArrayList<IntrinsicHolderTagsProvider.IntrinsicTagAppender>();
        clothingTags.add(clothesHat);
        clothingTags.add(clothesTorso);
        clothingTags.add(clothesPants);
        clothingTags.add(clothesSocks);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender curiosHat = this.tag(CURIOS_HAT).replace(false);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender curiosPants = this.tag(CURIOS_PANTS).replace(false);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender curiosSocks = this.tag(CURIOS_SOCKS).replace(false);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender curiosTorso = this.tag(CURIOS_TORSO).replace(false);
        ArrayList<IntrinsicHolderTagsProvider.IntrinsicTagAppender> curios_tags = new ArrayList<IntrinsicHolderTagsProvider.IntrinsicTagAppender>();
        curios_tags.add(curiosHat);
        curios_tags.add(curiosTorso);
        curios_tags.add(curiosPants);
        curios_tags.add(curiosSocks);
        TextileItems.BLACK_BEAR_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, clothingTags));
        TextileItems.CARIBOU_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, clothingTags));
        TextileItems.COUGAR_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, clothingTags));
        TextileItems.CROCODILE_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, clothingTags));
        TextileItems.DIREWOLF_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, clothingTags));
        TextileItems.GRIZZLY_BEAR_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, clothingTags));
        TextileItems.LION_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, clothingTags));
        TextileItems.PANTHER_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, clothingTags));
        TextileItems.POLAR_BEAR_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, clothingTags));
        TextileItems.RAW_HIDE_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, clothingTags));
        TextileItems.SABERTOOTH_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, clothingTags));
        TextileItems.TIGER_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, clothingTags));
        TextileItems.BLACK_BEAR_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, curios_tags));
        TextileItems.CARIBOU_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, curios_tags));
        TextileItems.COUGAR_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, curios_tags));
        TextileItems.CROCODILE_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, curios_tags));
        TextileItems.DIREWOLF_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, curios_tags));
        TextileItems.GRIZZLY_BEAR_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, curios_tags));
        TextileItems.LION_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, curios_tags));
        TextileItems.PANTHER_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, curios_tags));
        TextileItems.POLAR_BEAR_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, curios_tags));
        TextileItems.RAW_HIDE_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, curios_tags));
        TextileItems.SABERTOOTH_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, curios_tags));
        TextileItems.TIGER_CLOTHES.forEach(item -> this.addClothingTags((DeferredItem<Item>)item, curios_tags));
        this.tag(TextileItemTags.PRIMITIVE_INSULATION_KNAPPING).replace(false).add((Object)((Item)TextileItems.PRIMITIVE_INSULATION.get()));
        this.tag(TextileItemTags.REPLACEABLE_HIDE).replace(false).add((Object)((Item)((TFCItems.ItemId)((Map)TFCItems.HIDES.get(HideItemType.RAW)).get(HideItemType.Size.MEDIUM)).get())).add((Object)((Item)((TFCItems.ItemId)((Map)TFCItems.HIDES.get(HideItemType.RAW)).get(HideItemType.Size.LARGE)).get()));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender furTag = this.tag(TextileItemTags.FURS).replace(false);
        TextileItems.FURS.forEach(item -> furTag.add((Object)((Item)item.get())));
    }

    private void addClothingTags(DeferredItem<Item> item, ArrayList<IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tags) {
        if (item.getId().toString().contains("helmet")) {
            tags.get(0).add((Object)((Item)item.get()));
        } else if (item.getId().toString().contains("chestplate")) {
            tags.get(1).add((Object)((Item)item.get()));
        } else if (item.getId().toString().contains("leggings")) {
            tags.get(2).add((Object)((Item)item.get()));
        } else {
            tags.get(3).add((Object)((Item)item.get()));
        }
    }

    private ResourceLocation tfcItem(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)name);
    }
}

