/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.tfc_textile.registries;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.atobaazul.tfc_textile.common.item.TextileClothingItem;
import net.atobaazul.tfc_textile.registries.TextileMaterials;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TextileItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"tfc_textile_legacy");
    private static final List<ArmorItem.Type> equipSlots = ImmutableList.of((Object)ArmorItem.Type.HELMET, (Object)ArmorItem.Type.CHESTPLATE, (Object)ArmorItem.Type.LEGGINGS, (Object)ArmorItem.Type.BOOTS);
    public static final List<DeferredItem<Item>> BLACK_BEAR_CLOTHES = TextileItems.armorSet("black_bear", TextileMaterials.BLACK_BEAR_MATERIAL);
    public static final List<DeferredItem<Item>> CARIBOU_CLOTHES = TextileItems.armorSet("caribou", TextileMaterials.CARIBOU_MATERIAL);
    public static final List<DeferredItem<Item>> COUGAR_CLOTHES = TextileItems.armorSet("cougar", TextileMaterials.COUGAR_MATERIAL);
    public static final List<DeferredItem<Item>> CROCODILE_CLOTHES = TextileItems.armorSet("crocodile", TextileMaterials.CROCODILE_MATERIAL);
    public static final List<DeferredItem<Item>> DIREWOLF_CLOTHES = TextileItems.armorSet("direwolf", TextileMaterials.DIREWOLF_MATERIAL);
    public static final List<DeferredItem<Item>> GRIZZLY_BEAR_CLOTHES = TextileItems.armorSet("grizzly_bear", TextileMaterials.GRIZZLY_BEAR_MATERIAL);
    public static final List<DeferredItem<Item>> LION_CLOTHES = TextileItems.armorSet("lion", TextileMaterials.LION_MATERIAL);
    public static final List<DeferredItem<Item>> PANTHER_CLOTHES = TextileItems.armorSet("panther", TextileMaterials.PANTHER_MATERIAL);
    public static final List<DeferredItem<Item>> POLAR_BEAR_CLOTHES = TextileItems.armorSet("polar_bear", TextileMaterials.POLAR_BEAR_MATERIAL);
    public static final List<DeferredItem<Item>> RAW_HIDE_CLOTHES = TextileItems.armorSet("raw", TextileMaterials.RAW_HIDE_MATERIAL);
    public static final List<DeferredItem<Item>> SABERTOOTH_CLOTHES = TextileItems.armorSet("sabertooth", TextileMaterials.SABERTOOTH_MATERIAL);
    public static final List<DeferredItem<Item>> TIGER_CLOTHES = TextileItems.armorSet("tiger", TextileMaterials.TIGER_MATERIAL);
    public static final List<DeferredItem<Item>> FURS = ImmutableList.of(TextileItems.furItem("black_bear"), TextileItems.furItem("caribou"), TextileItems.furItem("cougar"), TextileItems.basicItem("crocodile_leather"), TextileItems.furItem("direwolf"), TextileItems.furItem("grizzly_bear"), TextileItems.furItem("lion"), TextileItems.furItem("panther"), TextileItems.furItem("polar_bear"), TextileItems.furItem("sabertooth"), TextileItems.furItem("tiger"));
    public static final DeferredItem<Item> PRIMITIVE_INSULATION = TextileItems.basicItem("primitive_insulation");

    private static List<DeferredItem<Item>> armorSet(String name, Holder<ArmorMaterial> material) {
        ArrayList<DeferredItem<Item>> armors = new ArrayList<DeferredItem<Item>>();
        equipSlots.forEach(slot -> armors.add(ITEMS.register(name + "_" + slot.toString().toLowerCase(), () -> new TextileClothingItem(material, (ArmorItem.Type)slot, new Item.Properties().stacksTo(1).durability(1)))));
        return armors;
    }

    private static DeferredItem<Item> basicItem(String name) {
        return ITEMS.register(name, () -> new Item(new Item.Properties().stacksTo(32)));
    }

    private static DeferredItem<Item> furItem(String name) {
        return ITEMS.register(name + "_fur", () -> new Item(new Item.Properties().stacksTo(32)));
    }
}

