/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.tfc_textile.registries;

import com.lumintorious.tfcambiental.api.EquipmentTemperatureProvider;
import com.lumintorious.tfcambiental.data.TemperatureModifier;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.atobaazul.tfc_textile.TFCTextileUtil;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TextileMaterials {
    public static final DeferredRegister<ArmorMaterial> CLOTHES_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"tfc_textile_legacy");
    public static Map<ArmorMaterial, EquipmentTemperatureProvider> tempMappings = new HashMap<ArmorMaterial, EquipmentTemperatureProvider>();
    public static final Holder<ArmorMaterial> BLACK_BEAR_MATERIAL = TextileMaterials.createClothArmorMaterial("black_bear", 4.0f, -0.15f);
    public static final Holder<ArmorMaterial> CARIBOU_MATERIAL = TextileMaterials.createClothArmorMaterial("caribou", 6.0f, -0.15f, -0.15f);
    public static final Holder<ArmorMaterial> COUGAR_MATERIAL = TextileMaterials.createClothArmorMaterial("cougar", 4.0f, -0.15f);
    public static final Holder<ArmorMaterial> CROCODILE_MATERIAL = TextileMaterials.createClothArmorMaterial("crocodile", -5.0f, -0.25f, -0.25f);
    public static final Holder<ArmorMaterial> DIREWOLF_MATERIAL = TextileMaterials.createClothArmorMaterial("direwolf", 5.0f, -0.15f);
    public static final Holder<ArmorMaterial> GRIZZLY_BEAR_MATERIAL = TextileMaterials.createClothArmorMaterial("grizzly_bear", 4.0f, -0.15f);
    public static final Holder<ArmorMaterial> LION_MATERIAL = TextileMaterials.createClothArmorMaterial("lion", 3.0f, -0.2f, 0.15f);
    public static final Holder<ArmorMaterial> PANTHER_MATERIAL = TextileMaterials.createClothArmorMaterial("panther", 4.0f, -0.15f);
    public static final Holder<ArmorMaterial> POLAR_BEAR_MATERIAL = TextileMaterials.createClothArmorMaterial("polar_bear", 6.0f, -0.15f, -0.15f);
    public static final Holder<ArmorMaterial> RAW_HIDE_MATERIAL = TextileMaterials.createClothArmorMaterial("raw_hide", 2.0f, -0.1f);
    public static final Holder<ArmorMaterial> SABERTOOTH_MATERIAL = TextileMaterials.createClothArmorMaterial("sabertooth", 4.0f, -0.15f);
    public static final Holder<ArmorMaterial> TIGER_MATERIAL = TextileMaterials.createClothArmorMaterial("tiger", 4.0f, -0.15f);

    public static Holder<ArmorMaterial> createClothArmorMaterial(String name, float change, float potency) {
        ArmorMaterial material = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 1);
            map.put(ArmorItem.Type.LEGGINGS, 2);
            map.put(ArmorItem.Type.CHESTPLATE, 2);
            map.put(ArmorItem.Type.HELMET, 1);
            map.put(ArmorItem.Type.BODY, 4);
        }), 0, Holder.direct((Object)SoundEvents.WOOL_PLACE), () -> Ingredient.EMPTY, List.of(new ArmorMaterial.Layer(TFCTextileUtil.TextileResource(name), "", true), new ArmorMaterial.Layer(TFCTextileUtil.TextileResource(name), "", false)), 1.0f, 0.0f);
        tempMappings.put(material, (player, stack) -> Optional.of(new TemperatureModifier("clothes", change, potency)));
        return CLOTHES_MATERIALS.register(name, () -> material);
    }

    public static Holder<ArmorMaterial> createClothArmorMaterial(String name, float change, float potency, float wetness) {
        ArmorMaterial material = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 1);
            map.put(ArmorItem.Type.LEGGINGS, 2);
            map.put(ArmorItem.Type.CHESTPLATE, 2);
            map.put(ArmorItem.Type.HELMET, 1);
            map.put(ArmorItem.Type.BODY, 4);
        }), 0, Holder.direct((Object)SoundEvents.WOOL_PLACE), () -> Ingredient.EMPTY, List.of(new ArmorMaterial.Layer(TFCTextileUtil.TextileResource(name), "", true), new ArmorMaterial.Layer(TFCTextileUtil.TextileResource(name), "", false)), 1.0f, 0.0f);
        tempMappings.put(material, (player, stack) -> Optional.of(new TemperatureModifier("clothes", change, potency, wetness)));
        return CLOTHES_MATERIALS.register(name, () -> material);
    }

    public static EquipmentTemperatureProvider temperatureOf(ArmorMaterial material) {
        return tempMappings.get(material);
    }
}

