/*
 * Decompiled with CFR 0.152.
 */
package net.glitchifyed.quick_hotkeys.event;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.glitchifyed.quick_hotkeys.client.QuickHotkeysClient;
import net.glitchifyed.quick_hotkeys.config.QuickHotkeysConfig;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9284;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class KeyInputHandler {
    public static final String KEY_CATEGORY = "key.category.glitchifyed.quick_hotkeys";
    public static final String KEY_ELYTRA = "key.glitchifyed.quick_hotkeys.equip_elytra";
    public static final String KEY_TOTEM = "key.glitchifyed.quick_hotkeys.equip_totem";
    public static final String KEY_AUTO = "key.glitchifyed.quick_hotkeys.automatic_elytra";
    public static class_304 equipElytraKeyBinding;
    public static class_304 equipTotemKeyBinding;
    public static class_304 toggleAutoElytraBinding;
    private static boolean elytraPressed;
    private static boolean totemPressed;
    private static boolean autoPressed;
    private static boolean elytraGliding;
    private static final int ARMOUR_SLOT = 6;
    private static final int CHESTPLATE_SLOT = 38;
    private static final int OFFHAND_SLOT1 = 45;
    private static final int OFFHAND_SLOT2 = 40;
    private static int fireworkSlot;
    private static class_310 CLIENT;
    private static class_746 PLAYER;

    public static void initialiseKeyInputHandler() {
        CLIENT = QuickHotkeysClient.CLIENT;
        equipElytraKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304(KEY_ELYTRA, class_3675.class_307.field_1668, 71, KEY_CATEGORY));
        equipTotemKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304(KEY_TOTEM, class_3675.class_307.field_1668, 88, KEY_CATEGORY));
        toggleAutoElytraBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304(KEY_AUTO, class_3675.class_307.field_1668, 82, KEY_CATEGORY));
        KeyInputHandler.registerCurrentKeyInputs();
    }

    public static void registerCurrentKeyInputs() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            KeyInputHandler.checkElytraSwapInput();
            KeyInputHandler.attemptTotemSwap();
            KeyInputHandler.toggleAutoElytra();
        });
        ClientTickEvents.END_WORLD_TICK.register(world -> KeyInputHandler.checkFireworkSwap());
    }

    private static void checkFireworkSwap() {
        class_1799 offhandStack;
        boolean attemptSwap;
        boolean lastGliding = elytraGliding;
        boolean changedGliding = lastGliding != (elytraGliding = KeyInputHandler.CLIENT.field_1724.method_6128());
        boolean bl = attemptSwap = elytraGliding && fireworkSlot == -1 || !elytraGliding && fireworkSlot != -1;
        if (QuickHotkeysConfig.fireworkRestockEnabled && elytraGliding && fireworkSlot != -1 && !KeyInputHandler.isItemFirework(offhandStack = KeyInputHandler.CLIENT.field_1724.method_6079())) {
            KeyInputHandler.attemptFireworkSwap();
            KeyInputHandler.attemptFireworkSwap();
        }
        if (!changedGliding || !QuickHotkeysConfig.fireworkSwapEnabled) {
            return;
        }
        if (attemptSwap) {
            KeyInputHandler.attemptFireworkSwap();
        }
    }

    private static void checkElytraSwapInput() {
        if (!equipElytraKeyBinding.method_1434()) {
            elytraPressed = false;
            return;
        }
        if (elytraPressed) {
            return;
        }
        elytraPressed = true;
        KeyInputHandler.attemptElytraSwap(0, true);
    }

    private static void toggleAutoElytra() {
        boolean enabled;
        if (!toggleAutoElytraBinding.method_1434()) {
            autoPressed = false;
            return;
        }
        if (autoPressed) {
            return;
        }
        autoPressed = true;
        QuickHotkeysConfig.autoSwapEnabled = enabled = !QuickHotkeysConfig.autoSwapEnabled;
        KeyInputHandler.CLIENT.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)(enabled ? "[Quick Hotkeys] Enabled automatic elytra swapping" : "[Quick Hotkeys] Disabled automatic elytra swapping")));
    }

    public static boolean attemptElytraSwap(int swapMode, boolean playError) {
        class_1799 offhandSlot;
        boolean swapOnlyChestplate;
        PLAYER = KeyInputHandler.CLIENT.field_1724;
        class_1661 playerInventory = PLAYER.method_31548();
        class_2371 inventory = playerInventory.method_67533();
        class_1799 chestplateSlot = playerInventory.method_5438(38);
        boolean wearingNothing = chestplateSlot.method_7909() == class_1802.field_8162;
        boolean wearingElytra = !wearingNothing && KeyInputHandler.isItemElytra(chestplateSlot);
        boolean wearingChestplate = !wearingElytra;
        boolean swapIsElytra = !wearingElytra;
        boolean swapBothWays = swapMode == 0;
        boolean swapOnlyElytra = swapMode == 1;
        boolean bl = swapOnlyChestplate = swapMode == 2;
        if (swapOnlyElytra ? wearingElytra : swapOnlyChestplate && !wearingElytra) {
            return false;
        }
        if (swapBothWays && KeyInputHandler.doesItemGoInChestplateSlot(offhandSlot = PLAYER.method_6079()) && (wearingNothing || wearingChestplate && KeyInputHandler.isItemElytra(offhandSlot) || wearingElytra)) {
            KeyInputHandler.CLIENT.field_1761.method_2906(KeyInputHandler.PLAYER.field_7498.field_7763, 6, 40, class_1713.field_7791, (class_1657)PLAYER);
            QuickHotkeysClient.PlaySound(swapIsElytra ? (class_3414)class_3417.field_14966.comp_349() : (class_3414)class_3417.field_14883.comp_349(), 1.0f, 1.0f);
            return true;
        }
        int swapSlot = -1;
        int priorityDurability = -1;
        int priorityEnchants = -1;
        for (class_1799 itemStack : inventory) {
            int enchants;
            int durability;
            class_1792 item = itemStack.method_7909();
            if (item == class_1802.field_8162 || !KeyInputHandler.doesItemGoInChestplateSlot(itemStack)) continue;
            boolean isElytra = KeyInputHandler.isItemElytra(itemStack);
            if (wearingElytra && isElytra || wearingChestplate && !isElytra) continue;
            if (!wearingElytra) {
                durability = (int)((float)(itemStack.method_7936() - itemStack.method_7919()) * ((float)KeyInputHandler.getEnchantCountOfItemStack(itemStack) * 0.5f + 1.0f));
                if (durability <= priorityDurability) continue;
                priorityDurability = durability;
                swapSlot = inventory.indexOf((Object)itemStack);
                continue;
            }
            durability = itemStack.method_7936();
            if (durability > priorityDurability) {
                priorityDurability = durability;
                priorityEnchants = -1;
            }
            if (durability < priorityDurability || (enchants = KeyInputHandler.getEnchantCountOfItemStack(itemStack)) <= priorityEnchants) continue;
            priorityEnchants = enchants;
            swapSlot = inventory.indexOf((Object)itemStack);
        }
        if (swapSlot == -1) {
            if (playError) {
                QuickHotkeysClient.PlaySound((class_6880.class_6883<class_3414>)class_3417.field_18309, 1.0f);
            }
            return false;
        }
        KeyInputHandler.attemptToSwapSlot(swapSlot, 6);
        QuickHotkeysClient.PlaySound(swapIsElytra ? (class_3414)class_3417.field_14966.comp_349() : (class_3414)class_3417.field_14883.comp_349(), 1.0f, 1.0f);
        return true;
    }

    private static void attemptTotemSwap() {
        if (!equipTotemKeyBinding.method_1434()) {
            totemPressed = false;
            return;
        }
        if (totemPressed) {
            return;
        }
        totemPressed = true;
        PLAYER = KeyInputHandler.CLIENT.field_1724;
        int swapSlot = -1;
        class_1661 playerInventory = PLAYER.method_31548();
        class_2371 inventory = playerInventory.method_67533();
        class_1799 offhandStack = PLAYER.method_6079();
        boolean swapToOne = !KeyInputHandler.isItemTotem(offhandStack);
        for (class_1799 itemStack : inventory) {
            if (swapToOne && !KeyInputHandler.isItemTotem(itemStack) || !swapToOne && !KeyInputHandler.isItemOffhandOption(itemStack)) continue;
            swapSlot = inventory.indexOf((Object)itemStack);
            break;
        }
        if (swapSlot == -1) {
            QuickHotkeysClient.PlaySound((class_6880.class_6883<class_3414>)class_3417.field_18309, 1.0f);
            return;
        }
        KeyInputHandler.attemptToSwapSlot(swapSlot, 45);
        QuickHotkeysClient.PlaySound((class_3414)class_3417.field_14883.comp_349(), 1.0f, 1.0f);
    }

    private static void attemptFireworkSwap() {
        PLAYER = KeyInputHandler.CLIENT.field_1724;
        int swapSlot = -1;
        if (fireworkSlot != -1) {
            swapSlot = fireworkSlot;
            fireworkSlot = -1;
        } else {
            class_1799 offhandSlot = PLAYER.method_6079();
            if (KeyInputHandler.isItemFirework(offhandSlot)) {
                return;
            }
            int highestDuration = -1;
            class_1661 playerInventory = PLAYER.method_31548();
            class_2371 inventory = playerInventory.method_67533();
            for (class_1799 itemStack : inventory) {
                class_9284 fireworksComponent;
                if (!KeyInputHandler.isItemFirework(itemStack)) continue;
                if (highestDuration != -2 && (fireworksComponent = (class_9284)itemStack.method_58694(class_9334.field_49616)) != null) {
                    int duration = fireworksComponent.comp_2391();
                    if (duration <= highestDuration) continue;
                    highestDuration = duration;
                    swapSlot = inventory.indexOf((Object)itemStack);
                    continue;
                }
                highestDuration = -2;
                swapSlot = inventory.indexOf((Object)itemStack);
            }
            if (swapSlot == -1) {
                return;
            }
            fireworkSlot = swapSlot;
        }
        KeyInputHandler.attemptToSwapSlot(swapSlot, 45);
    }

    private static int getEnchantCountOfItemStack(class_1799 itemStack) {
        int count = 0;
        class_9304 enchantments = class_1890.method_57532((class_1799)itemStack);
        for (class_6880 entry : enchantments.method_57534()) {
            count += enchantments.method_57536(entry);
        }
        return count;
    }

    private static boolean doesItemGoInChestplateSlot(class_1799 itemStack) {
        if (itemStack.method_7909() == class_1802.field_8162) {
            return false;
        }
        PLAYER = KeyInputHandler.CLIENT.field_1724;
        return PLAYER.method_32326(itemStack) == class_1304.field_6174;
    }

    private static boolean isItemElytra(class_1799 itemStack) {
        return QuickHotkeysConfig.elytraSwapItems.contains(itemStack.method_7909());
    }

    private static boolean isItemTotem(class_1799 itemStack) {
        return QuickHotkeysConfig.totemSwapItems.contains(itemStack.method_7909());
    }

    private static boolean isItemFirework(class_1799 itemStack) {
        return QuickHotkeysConfig.fireworkSwapItems.contains(itemStack.method_7909());
    }

    private static boolean isItemOffhandOption(class_1799 itemStack) {
        return QuickHotkeysConfig.offhandSwapItems.contains(itemStack.method_7909());
    }

    private static void attemptToSwapSlot(int slotId, int equippedSlotId) {
        PLAYER = KeyInputHandler.CLIENT.field_1724;
        if (slotId < 9) {
            KeyInputHandler.CLIENT.field_1761.method_2906(KeyInputHandler.PLAYER.field_7498.field_7763, equippedSlotId, slotId, class_1713.field_7791, (class_1657)PLAYER);
        } else {
            KeyInputHandler.CLIENT.field_1761.method_2906(KeyInputHandler.PLAYER.field_7498.field_7763, slotId, 0, class_1713.field_7790, (class_1657)PLAYER);
            KeyInputHandler.CLIENT.field_1761.method_2906(KeyInputHandler.PLAYER.field_7498.field_7763, equippedSlotId, 0, class_1713.field_7790, (class_1657)PLAYER);
            KeyInputHandler.CLIENT.field_1761.method_2906(KeyInputHandler.PLAYER.field_7498.field_7763, slotId, 0, class_1713.field_7790, (class_1657)PLAYER);
        }
    }

    static {
        fireworkSlot = -1;
    }
}

