/*
 * Decompiled with CFR 0.152.
 */
package com.ryankshah.skyrimstamina.data;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class StaminaData {
    private static final float MAX_STAMINA = 100.0f;
    private static final float STAMINA_REGEN_RATE = 1.0f;
    private static final float SPRINT_DRAIN_RATE = 0.5f;
    private static final int EXHAUSTION_DURATION = 60;
    private float stamina = 100.0f;
    private boolean isExhausted = false;
    private int exhaustionTicks = 0;

    public void tick(Player player) {
        if (this.isExhausted) {
            --this.exhaustionTicks;
            if (this.exhaustionTicks <= 0) {
                this.isExhausted = false;
            }
            this.addStamina(0.3f);
            return;
        }
        if (player.isSprinting()) {
            this.drainStamina(0.5f);
            if (this.stamina <= 0.0f) {
                this.stamina = 0.0f;
                this.isExhausted = true;
                this.exhaustionTicks = 60;
                player.setSprinting(false);
            }
        } else {
            this.addStamina(1.0f);
        }
    }

    public void drainStamina(float amount) {
        this.stamina = Math.max(0.0f, this.stamina - amount);
    }

    public void addStamina(float amount) {
        this.stamina = Math.min(100.0f, this.stamina + amount);
    }

    public float getStamina() {
        return this.stamina;
    }

    public float getMaxStamina() {
        return 100.0f;
    }

    public boolean isExhausted() {
        return this.isExhausted;
    }

    public boolean canSprint() {
        return this.stamina > 0.0f && !this.isExhausted;
    }

    public int getExhaustionTicks() {
        return this.exhaustionTicks;
    }

    public void setStamina(float stamina) {
        this.stamina = Math.max(0.0f, Math.min(100.0f, stamina));
    }

    public float getSprintSpeedMultiplier() {
        if (this.stamina <= 0.0f || this.isExhausted) {
            return 0.0f;
        }
        float staminaPercent = this.stamina / 100.0f;
        if (staminaPercent > 0.3f) {
            return 1.3f;
        }
        return 0.8f + staminaPercent / 0.3f * 0.5f;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.putFloat("stamina", this.stamina);
        tag.putBoolean("exhausted", this.isExhausted);
        tag.putInt("exhaustionTicks", this.exhaustionTicks);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.stamina = ((Float)tag.getFloat("stamina").get()).floatValue();
        this.isExhausted = (Boolean)tag.getBoolean("exhausted").get();
        this.exhaustionTicks = (Integer)tag.getInt("exhaustionTicks").get();
    }
}

