/*
 * Decompiled with CFR 0.152.
 */
package com.ryankshah.skyrimstamina.mixin;

import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Inject(method={"finishUsingItem"}, at={@At(value="RETURN")})
    private void onFoodConsumed(Level level, LivingEntity entity, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack stack = (ItemStack)this;
        FoodProperties foodProperties = (FoodProperties)stack.get(DataComponents.FOOD);
        if (foodProperties != null && entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide()) {
                float healAmount = (float)foodProperties.nutrition() * 0.5f;
                player.heal(healAmount);
            }
        }
    }
}

