/*
 * Decompiled with CFR 0.152.
 */
package com.ryankshah.skyrimstamina.mixin.client;

import com.ryankshah.skyrimstamina.data.StaminaAccessor;
import com.ryankshah.skyrimstamina.data.StaminaData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Shadow
    @Final
    private RandomSource random;
    @Shadow
    @Final
    private Minecraft minecraft;
    private static final ResourceLocation FOOD_EMPTY_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/food_empty");
    private static final ResourceLocation FOOD_HALF_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/food_half");
    private static final ResourceLocation FOOD_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/food_full");

    @Inject(method={"renderFood"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderStaminaBar(GuiGraphics guiGraphics, Player player, int y, int x, CallbackInfo ci) {
        StaminaData staminaData = ((StaminaAccessor)player).skyrimstamina$getStaminaData();
        float currentStamina = staminaData.getStamina();
        float maxStamina = staminaData.getMaxStamina();
        boolean isExhausted = staminaData.isExhausted();
        int staminaLevel = Math.round(currentStamina / maxStamina * 20.0f);
        for (int i = 0; i < 10; ++i) {
            int posX = x - i * 8 - 9;
            int posY = y;
            if (isExhausted && this.minecraft.gui.getGuiTicks() % 2 == 0) {
                posY += this.random.nextInt(3) - 1;
            }
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, FOOD_EMPTY_SPRITE, posX, posY, 9, 9);
            int iconValue = i * 2;
            if (iconValue + 1 < staminaLevel) {
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, FOOD_FULL_SPRITE, posX, posY, 9, 9);
                continue;
            }
            if (iconValue + 1 != staminaLevel) continue;
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, FOOD_HALF_SPRITE, posX, posY, 9, 9);
        }
        ci.cancel();
    }
}

