#> afkannouncer:app/main.mcfunction
# Execute each minecraft tick

# Listeners
  # Listen for trigger afk
    scoreboard players enable @a afk
    execute as @a if score @s afk matches 1 run \
     function afkannouncer:app/afk/trigger

  # Listen for trigger config 
    scoreboard players enable @a afkannouncer.config
    execute as @a if score @s afkannouncer.config matches 1 run \
     function afkannouncer:config/dialog_config with storage afkannouncer:root

# Set scoreboard values for players
  # Set basic value for time until afk for all players
    execute as @a unless score @s afkannouncer.time_until_afk = @s afkannouncer.time_until_afk \
     run scoreboard players set @s afkannouncer.time_until_afk 300

  # Set the default value for the individual notification config 0 = no notification when you go afk, 1 = notification
    execute as @a unless entity @a[scores={afkannouncer.notification_self=1}] run \ 
      scoreboard players set @a afkannouncer.notification_self 1

  # Set the default value for the individual notification config 0 = no notification when someone else goes afk, 1 = notification
    execute as @a unless entity @a[scores={afkannouncer.notification_others=1}] run \ 
      scoreboard players set @a afkannouncer.notification_others 1

  # Set the default value for the individual notification config 0 = others wont see when you go afk, 1 = others will see when you go afk
    execute as @a unless entity @a[scores={afkannouncer.notification_visibility=1}] run \ 
      scoreboard players set @a afkannouncer.notification_visibility 1

  # Set the default value for the afkannouncer.individual_afk_kick config 0 = disabled, 1 = enabled
    execute as @a unless entity @a[scores={afkannouncer.individual_afk_kick=1}] run \ 
      scoreboard players set @a afkannouncer.individual_afk_kick 0

# Calculate afk_timer_ticks
  execute as @a run scoreboard players operation @s afkannouncer.time_until_afk_ticks = @s afkannouncer.time_until_afk 
  execute as @a run scoreboard players operation @s afkannouncer.time_until_afk_ticks *= #20 afkannouncer.time_until_afk_ticks

# When a player leaves the afk tag is removed
  execute if score &check_leave_game afkannouncer.config matches 1 as @a if score @s afkannouncer.leave_game matches 1 run \
   tag @s remove afkannouncer.afk 

  execute if score &check_leave_game afkannouncer.config matches 1 as @a if score @s afkannouncer.leave_game matches 1 run \
   scoreboard players set @s afkannouncer.leave_game 0

# Check player position
  # Remove all afk position tags
    tag @a remove afkannouncer.rotation.x.not_moving
    tag @a remove afkannouncer.rotation.y.not_moving

    execute as @a[predicate=afkannouncer:no_movement] run function afkannouncer:app/check/rotation

  # Reset afk time if player moves
    execute as @a[predicate=!afkannouncer:no_movement] run scoreboard players set @s afkannouncer.afk_time 0

# If no movement is detected, add 1 to afk_time of player
  execute if score &check_rotation afkannouncer.config matches 1 \
   as @a[tag=afkannouncer.rotation.x.not_moving,tag=afkannouncer.rotation.y.not_moving] \
    if predicate afkannouncer:no_movement run \
     scoreboard players add @s afkannouncer.afk_time 1 
  
  execute if score &check_rotation afkannouncer.config matches 0 \
   as @a if predicate afkannouncer:no_movement run \
     scoreboard players add @s afkannouncer.afk_time 1 

# Announce AFK
# If AFK Kick ist enabled
execute if score &afk_kick afkannouncer.config matches 1 \
 if score &players_decide_on_own afkannouncer.config matches 1 \
  as @a[tag=!afkannouncer.afk,scores={afkannouncer.afk_time=1..,afkannouncer.individual_afk_kick=1,afkannouncer.time_until_afk=1..}] \
   if score @s afkannouncer.afk_time >= @s afkannouncer.time_until_afk_ticks run \
   function afkannouncer:app/afk/announce

execute if score &afk_kick afkannouncer.config matches 1 \
 if score &players_decide_on_own afkannouncer.config matches 0 \
  as @a[tag=!afkannouncer.afk,scores={afkannouncer.afk_time=1..,afkannouncer.time_until_afk=1..}] \
   if score @s afkannouncer.afk_time >= @s afkannouncer.time_until_afk_ticks run \
   function afkannouncer:app/afk/announce

# If AFK Kick is disabled
execute if score &afk_kick afkannouncer.config matches 0 \
 as @a[tag=!afkannouncer.afk,scores={afkannouncer.afk_time=1..,afkannouncer.time_until_afk=1..}] \
  if score @s afkannouncer.afk_time >= @s afkannouncer.time_until_afk_ticks run \
   function afkannouncer:app/afk/announce

execute if score &afk_kick afkannouncer.config matches 0 \
 as @a[scores={afkannouncer.afk_time=1..,afkannouncer.time_until_afk=1..}] \
  if score @s afkannouncer.afk_time >= @s afkannouncer.time_until_afk_ticks run \
   tag @s[tag=!trigger_afk] add afkannouncer.afk

execute if score &afk_kick afkannouncer.config matches 1 \
 if score &players_decide_on_own afkannouncer.config matches 1 \
 as @a[tag=!afkannouncer.afk,scores={afkannouncer.afk_time=1..,afkannouncer.individual_afk_kick=0,afkannouncer.time_until_afk=1..}] \
 if score @s afkannouncer.afk_time >= @s afkannouncer.time_until_afk_ticks run \
 function afkannouncer:app/afk/announce

execute if score &afk_kick afkannouncer.config matches 1 \
 if score &players_decide_on_own afkannouncer.config matches 1 \
 as @a[tag=!afkannouncer.afk,scores={afkannouncer.afk_time=1..,afkannouncer.individual_afk_kick=0,afkannouncer.time_until_afk=1..}] \
 if score @s afkannouncer.afk_time >= @s afkannouncer.time_until_afk_ticks run \
 tag @s[tag=!trigger_afk] add afkannouncer.afk

# Announce Return
execute as @a[tag=afkannouncer.afk,scores={afkannouncer.afk_time=0..1, afkannouncer.time_until_afk_ticks=1..}] run \
 function afkannouncer:app/afk/return

# AFK Invulnerable
execute if score &afk_invulnerable afkannouncer.config matches 1 \
  run function afkannouncer:app/afk/invulnerable