/*
 * Decompiled with CFR 0.152.
 */
package com.stardevllc.starchat;

import com.stardevllc.starchat.ChatSelector;
import com.stardevllc.starchat.channels.ChatChannel;
import com.stardevllc.starchat.channels.GlobalChannel;
import com.stardevllc.starchat.channels.StaffChannel;
import com.stardevllc.starchat.commands.ChatCmd;
import com.stardevllc.starchat.commands.MessageCmd;
import com.stardevllc.starchat.commands.ReplyCmd;
import com.stardevllc.starchat.commands.StarChatAdminCmd;
import com.stardevllc.starchat.context.ChatContext;
import com.stardevllc.starchat.hooks.VaultHook;
import com.stardevllc.starchat.placeholder.DefaultPlaceholders;
import com.stardevllc.starchat.placeholder.PAPIExpansion;
import com.stardevllc.starchat.placeholder.PAPIPlaceholders;
import com.stardevllc.starchat.placeholder.PlaceholderHandler;
import com.stardevllc.starchat.pm.PrivateChatSelector;
import com.stardevllc.starchat.pm.PrivateMessage;
import com.stardevllc.starchat.registry.ChannelRegistry;
import com.stardevllc.starchat.registry.FocusRegistry;
import com.stardevllc.starchat.registry.RoomRegistry;
import com.stardevllc.starchat.registry.SpaceRegistry;
import com.stardevllc.starchat.space.ChatSpace;
import com.stardevllc.starcore.actor.Actor;
import com.stardevllc.starcore.actor.PlayerActor;
import com.stardevllc.starcore.actor.ServerActor;
import com.stardevllc.starcore.utils.Config;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;

public class StarChat
extends JavaPlugin
implements Listener {
    private static StarChat instance;
    public static final Function<Player, String> vaultDisplayNameFunction;
    private SpaceRegistry spaceRegistry;
    private ChannelRegistry channelRegistry;
    private RoomRegistry roomRegistry;
    private FocusRegistry playerChatSelection;
    private PlaceholderHandler placeholderHandler;
    private Config mainConfig;
    private ChatChannel globalChannel;
    private ChatChannel staffChannel;
    private Map<String, ChatSelector> chatSelectors = new HashMap<String, ChatSelector>();
    private PAPIExpansion papiExpansion;
    private VaultHook vaultHook;
    private Set<PrivateMessage> privateMessages = new HashSet<PrivateMessage>();
    private Map<UUID, PrivateMessage> lastMessage = new HashMap<UUID, PrivateMessage>();
    private PrivateMessage consoleLastMessage;

    public void onEnable() {
        instance = this;
        this.mainConfig = new Config(new File(this.getDataFolder(), "config.yml"));
        Plugin vaultPlugin = this.getServer().getPluginManager().getPlugin("Vault");
        if (vaultPlugin != null && vaultPlugin.isEnabled()) {
            this.vaultHook = new VaultHook(this);
            if (!this.vaultHook.setup()) {
                this.vaultHook = null;
            }
        }
        this.spaceRegistry = new SpaceRegistry();
        this.channelRegistry = new ChannelRegistry(this);
        this.roomRegistry = new RoomRegistry(this);
        this.playerChatSelection = new FocusRegistry();
        this.generateDefaultConfigOptions();
        this.loadDefaultChannels();
        this.loadChannels();
        this.determinePlaceholderHandler();
        ServicesManager servicesManager = this.getServer().getServicesManager();
        servicesManager.register(SpaceRegistry.class, (Object)this.spaceRegistry, (Plugin)this, ServicePriority.Highest);
        servicesManager.register(ChannelRegistry.class, (Object)this.channelRegistry, (Plugin)this, ServicePriority.Highest);
        servicesManager.register(RoomRegistry.class, (Object)this.roomRegistry, (Plugin)this, ServicePriority.Highest);
        servicesManager.register(FocusRegistry.class, (Object)this.playerChatSelection, (Plugin)this, ServicePriority.Highest);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.addSelector(new PrivateChatSelector());
        this.getCommand("chat").setExecutor((CommandExecutor)new ChatCmd(this));
        this.getCommand("message").setExecutor((CommandExecutor)new MessageCmd(this));
        this.getCommand("reply").setExecutor((CommandExecutor)new ReplyCmd(this));
        this.getCommand("starchat").setExecutor((CommandExecutor)new StarChatAdminCmd(this));
    }

    public void reload(boolean save) {
        if (save) {
            this.mainConfig.save();
            for (ChatChannel channel : this.channelRegistry.getObjects().values()) {
                channel.getConfig().save();
            }
        }
        this.mainConfig = new Config(new File(this.getDataFolder(), "config.yml"));
        HashSet<String> spacesToRemove = new HashSet<String>();
        for (ChatSpace space : this.spaceRegistry.getObjects().values()) {
            if (!space.getPlugin().getName().equalsIgnoreCase(this.getName())) continue;
            spacesToRemove.add(space.getName());
        }
        spacesToRemove.forEach(c -> this.channelRegistry.unregister((String)c));
        this.generateDefaultConfigOptions();
        this.loadDefaultChannels();
        this.loadChannels();
        this.determinePlaceholderHandler();
        this.addSelector(new PrivateChatSelector());
    }

    private void generateDefaultConfigOptions() {
        this.mainConfig.addDefault("console-name-format", (Object)"&4Console", new String[]{"The name that the console appears as in chat spaces."});
        this.mainConfig.addDefault("private-msg-format", (Object)"&6[&c{from} &6-> &c{to}&6]&8: &f{message}", new String[]{"The format used for private messaging."});
        this.mainConfig.addDefault("use-placeholderapi", (Object)true, new String[]{"If the PlaceholderAPI plugin is supported by default.", "If PlaceholderAPI is not installed, this setting is ignored.", "Note: Other plugins that use the systems of StarChat can override this setting", "This setting only applies to the default state of StarChat, and maybe other plugins if they decide to use this setting."});
        this.mainConfig.addDefault("use-color-permissioins", (Object)false, new String[]{"This allows you to control color usage by permissions.", "This is false by default and will just color all messages.", "Permissions for default colors follows the format: starmclib.color.spigot.<colorname>.", "Colors added by other plugins and via StarCore's color commands may or may not have permissions. Please see StarCore for how to list the colors and their information."});
        this.mainConfig.addDefault("messages.command.nopermission", (Object)"&cYou do not have permission to use that command.", new String[0]);
        this.mainConfig.addDefault("messages.command.onlyplayers", (Object)"&cOnly players can use that command.", new String[0]);
        this.mainConfig.addDefault("messages.chatspace.notexist", (Object)"&cSorry but {PROVIDED} is not a valid chat space.", new String[0]);
        this.mainConfig.addDefault("messages.channel.nosendpermission", (Object)"&cYou do not have permission to send messages in {CHANNEL}.", new String[0]);
        this.mainConfig.addDefault("messages.room.notamember", (Object)"&cYou are not a member of {ROOM}", new String[0]);
        this.mainConfig.addDefault("messages.command.chat.setfocus", (Object)"&eYou set your chat focus to &b{SPACE}.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.savesuccess", (Object)"&aSaved config.yml successfully.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.reloadsuccess", (Object)"&aReloaded successfully.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.setconsolename", (Object)"&eYou set the new console name format to &r{NEWNAME}", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.setusepapi.alreadyconfigandenabled", (Object)"&cPlaceholderAPI is already enabled and configured, no need to set it again.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.setusepapi.configbutnotenabled", (Object)"&aStarChat was configured to use PlaceholderAPI but was not able to load hook at startup, however, PlaceholderAPI was detected on this command and hook has been enabled now.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.setusepapi.configbutnotdetected", (Object)"&cStarChat is configured to use PlaceholderAPI, however, it was not detected, so the hook cannot be registered. Please install PlaceholderAPI and restart the server.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.setusepapi.detectedandenabled", (Object)"&aPlaceholderAPI has been detected and hooked into, StarChat will now respect PlaceholderAPI placeholders.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.setusepapi.notdetectednotenabled", (Object)"&cPlaceholderAPI is not detected as a plugin, cannot enable PlaceholderAPI support for StarChat. Please install and restart the server.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.setusepapi.alreadydisabled", (Object)"&cPlaceholderAPI support is already disabled.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.setusepapi.disabledsuccess", (Object)"&Successfully disabled PlaceholderAPI hook and switched to using default placeholder replacements.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.setusecolorperms.alreadyenabled", (Object)"&cUsage of color permissions is already enabled.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.setusecolorperms.enabled", (Object)"&aYou enabled the use of color based permissions.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.setusecolorperms.alreadydisabled", (Object)"&cUsage of color permissions is already disabled.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.setusecolorperms.disabled", (Object)"&aYou disabled the use of color based permissions.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.list.all.header", (Object)"&aList of all chat spaces registered to StarChat.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.list.channels.header", (Object)"&aList of all chat channels registered to StarChat.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.list.rooms.header", (Object)"&aList of all chat rooms registered to StarChat.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.list.conversations.header", (Object)"&aList of all conversations using StarChat.", new String[0]);
        this.mainConfig.addDefault("messages.command.admin.channel.set.success", (Object)"&eYou set &b{channel}&e's &a{key} &eto &d{value}", new String[0]);
        this.mainConfig.save();
    }

    private void determinePlaceholderHandler() {
        this.setUsePlaceholderAPI(this.getMainConfig().getBoolean("use-placeholderapi"));
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null && this.isUsePlaceholderAPI()) {
            this.placeholderHandler = new PAPIPlaceholders();
            this.papiExpansion = new PAPIExpansion(this);
            this.papiExpansion.register();
        } else {
            this.placeholderHandler = new DefaultPlaceholders();
        }
    }

    private void loadChannels() {
        File channelsDirectory = new File(this.getDataFolder(), "channels");
        for (File file : channelsDirectory.listFiles()) {
            if (file.isDirectory() || !file.getName().endsWith(".yml")) continue;
            Config config = new Config(file);
            String name = config.getString("name");
            ChatChannel chatChannel = new ChatChannel(this, name, file.toPath());
            this.channelRegistry.register(chatChannel.getName(), chatChannel);
        }
    }

    private void loadDefaultChannels() {
        this.globalChannel = new GlobalChannel(this, new File(this.getDataFolder() + File.separator + "channels", "global.yml"));
        this.channelRegistry.register(this.globalChannel.getName(), this.globalChannel);
        this.staffChannel = new StaffChannel(this, new File(this.getDataFolder() + File.separator + "channels", "staff.yml"));
        this.channelRegistry.register(this.staffChannel.getName(), this.staffChannel);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        ChatSpace chatSpace = this.getPlayerFocus(player);
        chatSpace.sendMessage(new ChatContext(e));
        e.setCancelled(true);
    }

    public SpaceRegistry getSpaceRegistry() {
        return this.spaceRegistry;
    }

    public PAPIExpansion getPapiExpansion() {
        return this.papiExpansion;
    }

    public void setPapiExpansion(PAPIExpansion papiExpansion) {
        this.papiExpansion = papiExpansion;
    }

    public PrivateMessage getLastMessage(UUID uuid) {
        return this.lastMessage.get(uuid);
    }

    public ChannelRegistry getChannelRegistry() {
        return this.channelRegistry;
    }

    public RoomRegistry getRoomRegistry() {
        return this.roomRegistry;
    }

    public Map<String, ChatSelector> getChatSelectors() {
        return this.chatSelectors;
    }

    public void assignLastMessage(CommandSender sender, StringBuilder msgBuilder, PrivateMessage privateMessage, Actor senderActor, Actor targetActor) {
        if (senderActor instanceof PlayerActor) {
            PlayerActor senderPlayerActor = (PlayerActor)senderActor;
            this.lastMessage.put(senderPlayerActor.getUniqueId(), privateMessage);
        } else if (senderActor instanceof ServerActor) {
            this.consoleLastMessage = privateMessage;
        }
        if (targetActor instanceof PlayerActor) {
            PlayerActor targetPlayerActor = (PlayerActor)targetActor;
            this.lastMessage.put(targetPlayerActor.getUniqueId(), privateMessage);
        } else if (targetActor instanceof ServerActor) {
            this.consoleLastMessage = privateMessage;
        }
    }

    public ChatChannel getGlobalChannel() {
        return this.globalChannel;
    }

    public ChatSpace getPlayerFocus(Player player) {
        return this.playerChatSelection.getPlayerFocus(player);
    }

    public void setPlayerFocus(Player player, ChatSpace chatSpace) {
        this.playerChatSelection.setPlayerFocus(player.getUniqueId(), chatSpace);
    }

    public Set<PrivateMessage> getPrivateMessages() {
        return this.privateMessages;
    }

    public PrivateMessage getPrivateMessage(Actor actor1, Actor actor2) {
        for (PrivateMessage privateMessage : this.privateMessages) {
            boolean containsActor1 = privateMessage.getActor1().equals((Object)actor1) || privateMessage.getActor2().equals((Object)actor1);
            boolean containsActor2 = privateMessage.getActor1().equals((Object)actor2) || privateMessage.getActor2().equals((Object)actor2);
            if (!containsActor2 || !containsActor1) continue;
            return privateMessage;
        }
        return null;
    }

    public List<PrivateMessage> getPrivateMessages(Actor actor) {
        ArrayList<PrivateMessage> privateMessages = new ArrayList<PrivateMessage>();
        for (PrivateMessage privateMessage : this.privateMessages) {
            if (!privateMessage.getActor1().equals((Object)actor) && !privateMessage.getActor2().equals((Object)actor)) continue;
            privateMessages.add(privateMessage);
        }
        return privateMessages;
    }

    public Config getMainConfig() {
        return this.mainConfig;
    }

    public void addSelector(ChatSelector selector) {
        this.chatSelectors.put(selector.getType().toLowerCase(), selector);
    }

    public String getConsoleNameFormat() {
        return this.mainConfig.getString("console-name-format");
    }

    public String getPrivateMessageFormat() {
        return this.mainConfig.getString("private-msg-format");
    }

    public boolean isUsePlaceholderAPI() {
        return this.mainConfig.getBoolean("use-placeholder-api");
    }

    public void setUsePlaceholderAPI(boolean usePlaceholderAPI) {
        this.mainConfig.set("use-placeholder-api", (Object)usePlaceholderAPI);
    }

    public VaultHook getVaultHook() {
        return this.vaultHook;
    }

    public ChatChannel getStaffChannel() {
        return this.staffChannel;
    }

    public PlaceholderHandler getPlaceholderHandler() {
        return this.placeholderHandler;
    }

    public boolean isUseColorPermissions() {
        return this.mainConfig.getBoolean("use-color-permissions");
    }

    public void addPrivateMessage(PrivateMessage privateMessage) {
        this.privateMessages.add(privateMessage);
    }

    public PrivateMessage getConsoleLastMessage() {
        return this.consoleLastMessage;
    }

    public void setConsoleNameFormat(String consoleNameFormat) {
        this.mainConfig.set("console-name-format", (Object)consoleNameFormat);
    }

    public void setPrivateMessageFormat(String privateMessageFormat) {
        this.mainConfig.set("private-message-format", (Object)privateMessageFormat);
    }

    public void setPlaceholderHandler(PlaceholderHandler playerPlaceholders) {
        this.placeholderHandler = playerPlaceholders;
    }

    public void setUseColorPermissions(boolean useColorPermissions) {
        this.mainConfig.set("use-color-permissions", (Object)useColorPermissions);
    }

    public static StarChat getInstance() {
        return instance;
    }

    static {
        vaultDisplayNameFunction = player -> {
            VaultHook vc = StarChat.getInstance().getVaultHook();
            if (vc == null) {
                return null;
            }
            return vc.getChat().getPlayerPrefix(player) + player.getName() + vc.getChat().getPlayerSuffix(player);
        };
    }
}

