/*
 * Decompiled with CFR 0.152.
 */
package com.stardevllc.starchat.channels;

import com.stardevllc.starchat.StarChat;
import com.stardevllc.starchat.context.ChatContext;
import com.stardevllc.starchat.space.ChatSpace;
import com.stardevllc.starcore.color.ColorUtils;
import com.stardevllc.starcore.utils.Config;
import com.stardevllc.starlib.observable.property.writable.BooleanProperty;
import com.stardevllc.starlib.observable.property.writable.LongProperty;
import com.stardevllc.starlib.observable.property.writable.StringProperty;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ChatChannel
implements ChatSpace {
    protected transient File file;
    protected transient Config config;
    protected final LongProperty id;
    protected final JavaPlugin plugin;
    protected final StringProperty name;
    protected final StringProperty viewPermission;
    protected final StringProperty sendPermission;
    protected final StringProperty senderFormat;
    protected final StringProperty systemFormat;
    protected final BooleanProperty useColorPermissions;
    protected Function<Player, String> displayNameHandler;

    public ChatChannel(JavaPlugin plugin, String name, Path filePath) {
        this.plugin = plugin;
        this.file = new File(filePath.toFile().getAbsolutePath());
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.config = new Config(this.file);
        this.id = new LongProperty((Object)this, "id");
        this.name = new StringProperty((Object)this, "name", name);
        this.createDefaults();
        this.name.addListener((observableValue, oldValue, newValue) -> this.config.set("name", newValue));
        this.viewPermission = new StringProperty((Object)this, "viewPermission", this.config.getString("permissions.view"));
        this.viewPermission.addListener((observableValue, oldValue, newValue) -> this.config.set("permissions.view", newValue));
        this.sendPermission = new StringProperty((Object)this, "sendPermission", this.config.getString("permissions.send"));
        this.sendPermission.addListener((observableValue, oldValue, newValue) -> this.config.set("permissions.send", newValue));
        this.senderFormat = new StringProperty((Object)this, "senderFormat", this.config.getString("formats.sender"));
        this.senderFormat.addListener((observableValue, oldValue, newValue) -> this.config.set("formats.sender", newValue));
        this.systemFormat = new StringProperty((Object)this, "systemFormat", this.config.getString("formats.system"));
        this.systemFormat.addListener((observableValue, oldValue, newValue) -> this.config.set("formats.system", newValue));
        this.useColorPermissions = new BooleanProperty((Object)this, "useColorPermissions", this.config.getBoolean("settings.usecolorpermissions").booleanValue());
        this.useColorPermissions.addListener((observableValue, oldValue, newValue) -> this.config.set("settings.usecolorpermissions", newValue));
    }

    protected void createDefaults() {
        this.config.addDefault("name", (Object)this.name.get(), new String[]{"The name of the channel.", "It is recommended to not change this name in the file and instead use commands."});
        this.config.addDefault("formats.sender", (Object)"", new String[]{"The format used when a Player or the Console sends a chat message in this channel."});
        this.config.addDefault("formats.system", (Object)"", new String[]{"The format used when a message is sent to this channel without a sender."});
        this.config.addDefault("permissions.view", (Object)"", new String[]{"The permission that is required to have in order for a player to receive messages from this channel."});
        this.config.addDefault("permissions.send", (Object)"", new String[]{"The permission that is required to have in order for a player to send messages in this channel."});
        this.config.addDefault("settings.usecolorpermissions", (Object)false, new String[]{"Whether or not to use fine-controlled color permissions from StarCore."});
        this.config.save();
    }

    public Config getConfig() {
        return this.config;
    }

    public File getFile() {
        return this.file;
    }

    public void saveConfig() {
        this.config.save();
    }

    public String getViewPermission() {
        return this.viewPermission.get();
    }

    public String getSendPermission() {
        return this.sendPermission.get();
    }

    @Override
    public void sendMessage(ChatContext context) {
        String format;
        Player player;
        String message;
        String displayName;
        if (context.getSender() == null) {
            displayName = "";
            message = ColorUtils.color((String)context.getMessage());
        } else {
            if (!this.canSendMessages(context.getSender())) {
                return;
            }
            CommandSender sender = context.getSender();
            if (context.getChatEvent() != null && context.getChatEvent().isCancelled() && !sender.hasPermission("starchat.channel.bypass.cancelledevent")) {
                return;
            }
            message = context.getMessage();
            message = this.useColorPermissions.get() ? ColorUtils.color((CommandSender)context.getSender(), (String)message) : ColorUtils.color((String)message);
            if (context.getSender() instanceof ConsoleCommandSender) {
                displayName = StarChat.getInstance().getConsoleNameFormat();
            } else {
                player = (Player)context.getSender();
                displayName = Objects.requireNonNullElse(this.displayNameHandler, StarChat.vaultDisplayNameFunction).apply(player);
            }
        }
        if (context.getSender() == null) {
            format = ColorUtils.color((String)this.systemFormat.get().replace("{message}", message));
        } else if (context.getSender() instanceof ConsoleCommandSender) {
            format = ColorUtils.color((String)this.senderFormat.get().replace("{displayname}", displayName)).replace("{message}", message);
        } else {
            player = (Player)context.getSender();
            format = ColorUtils.color((String)StarChat.getInstance().getPlaceholderHandler().setPlaceholders(player, this.senderFormat.get().replace("{displayname}", displayName))).replace("{message}", message);
        }
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            if (!this.canViewMessages((CommandSender)player2)) continue;
            player2.sendMessage(format);
        }
    }

    @Override
    public boolean canSendMessages(CommandSender sender) {
        if (sender != null) {
            if (this.getSendPermission() != null && !this.getSendPermission().isEmpty()) {
                return sender.hasPermission(this.getSendPermission());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canViewMessages(CommandSender sender) {
        if (sender != null) {
            if (this.getViewPermission() != null && !this.getViewPermission().isEmpty()) {
                return sender.hasPermission(this.getViewPermission());
            }
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    @Override
    public long getId() {
        return this.id.get();
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public Function<Player, String> getDisplayNameHandler() {
        return this.displayNameHandler;
    }

    public void setDisplayNameHandler(Function<Player, String> displayNameHandler) {
        this.displayNameHandler = displayNameHandler;
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public void setSenderFormat(String senderFormat) {
        this.senderFormat.set(senderFormat);
    }

    public void setSystemFormat(String systemFormat) {
        this.systemFormat.set(systemFormat);
    }

    public void setViewPermission(String viewPermission) {
        this.viewPermission.set(viewPermission);
    }

    public void setSendPermission(String sendPermission) {
        this.sendPermission.set(sendPermission);
    }

    public String getSenderFormat() {
        return this.senderFormat.get();
    }

    public String getSystemFormat() {
        return this.systemFormat.get();
    }

    public boolean isUseColorPermissions() {
        return this.useColorPermissions.get();
    }
}

