/*
 * Decompiled with CFR 0.152.
 */
package com.stardevllc.starchat.commands;

import com.stardevllc.starchat.ChatSelector;
import com.stardevllc.starchat.StarChat;
import com.stardevllc.starchat.channels.ChatChannel;
import com.stardevllc.starchat.rooms.ChatRoom;
import com.stardevllc.starchat.space.ChatSpace;
import com.stardevllc.starcore.color.ColorUtils;
import com.stardevllc.starcore.utils.Config;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatCmd
implements CommandExecutor {
    private StarChat plugin;
    private Config pluginConfig;

    public ChatCmd(StarChat plugin) {
        this.plugin = plugin;
        this.pluginConfig = plugin.getMainConfig();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        ChatRoom chatRoom;
        ChatSelector.ChatSelection selection;
        ChatSelector selector;
        if (!sender.hasPermission("starchat.command.chat")) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)this.plugin.getMainConfig().getString("messages.command.nopermission"));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ColorUtils.color((String)this.pluginConfig.getString("messages.command.onlyplayers")));
            return true;
        }
        Player player = (Player)sender;
        if (args.length <= 0) {
            sender.sendMessage(ColorUtils.color((String)("&cUsage: /" + label + " <channelName>")));
            return true;
        }
        String channelName = args[0].toLowerCase();
        String nameOverride = "";
        ChatSpace chatSpace = (ChatSpace)this.plugin.getChannelRegistry().get((Comparable)((Object)channelName));
        if (chatSpace == null) {
            chatSpace = (ChatSpace)this.plugin.getRoomRegistry().get((Comparable)((Object)channelName));
        }
        if (chatSpace == null && (selector = this.plugin.getChatSelectors().get(channelName)) != null && (selection = selector.getSelection(player, args)) != null) {
            chatSpace = selection.space();
            nameOverride = selection.nameOverride();
        }
        if (chatSpace == null) {
            sender.sendMessage(ColorUtils.color((String)this.pluginConfig.getString("messages.chatspace.notexist").replace("{PROVIDED}", channelName)));
            return true;
        }
        if (chatSpace instanceof ChatChannel) {
            ChatChannel chatChannel = (ChatChannel)chatSpace;
            String sendPermission = chatChannel.getSendPermission();
            if (!sendPermission.isEmpty() && !player.hasPermission(sendPermission)) {
                sender.sendMessage(ColorUtils.color((String)this.pluginConfig.getString("messages.channel.nosendpermission").replace("{CHANNEL}", chatChannel.getName())));
                return true;
            }
        } else if (chatSpace instanceof ChatRoom && !(chatRoom = (ChatRoom)chatSpace).isMember(player.getUniqueId())) {
            sender.sendMessage(ColorUtils.color((String)this.pluginConfig.getString("messages.room.notamember").replace("{ROOM}", chatRoom.getName())));
            return true;
        }
        this.plugin.setPlayerFocus(player, chatSpace);
        String spaceName = chatSpace.getName();
        if (nameOverride != null && !nameOverride.isEmpty()) {
            spaceName = nameOverride;
        }
        sender.sendMessage(ColorUtils.color((String)this.pluginConfig.getString("messages.command.chat.setfocus").replace("{SPACE}", spaceName)));
        return true;
    }
}

