/*
 * Decompiled with CFR 0.152.
 */
package com.stardevllc.starchat.commands;

import com.stardevllc.starchat.StarChat;
import com.stardevllc.starchat.context.ChatContext;
import com.stardevllc.starchat.pm.PrivateMessage;
import com.stardevllc.starcore.actor.Actor;
import com.stardevllc.starcore.color.ColorUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class MessageCmd
implements CommandExecutor {
    private StarChat plugin;

    public MessageCmd(StarChat plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("starchat.command.message")) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)this.plugin.getMainConfig().getString("messages.command.nopermission"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(ColorUtils.color((String)("&cUsage: /" + label + " <target> <message>")));
            return true;
        }
        Actor senderActor = Actor.create((Object)sender);
        Actor targetActor = Actor.create((Object)args[0]);
        if (targetActor == null) {
            sender.sendMessage(ColorUtils.color((String)"&cInvalid target. They must be online, or the console."));
            return true;
        }
        PrivateMessage privateMessage = this.plugin.getPrivateMessage(senderActor, targetActor);
        if (privateMessage == null) {
            privateMessage = new PrivateMessage(this.plugin, senderActor, targetActor, this.plugin.getMainConfig().getString("private-msg-format"));
            this.plugin.addPrivateMessage(privateMessage);
        }
        StringBuilder msgBuilder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            msgBuilder.append(args[i]).append(" ");
        }
        privateMessage.sendMessage(new ChatContext(sender, msgBuilder.toString().trim()));
        this.plugin.assignLastMessage(sender, msgBuilder, privateMessage, senderActor, targetActor);
        return true;
    }
}

