/*
 * Decompiled with CFR 0.152.
 */
package com.stardevllc.starchat.commands;

import com.stardevllc.starchat.StarChat;
import com.stardevllc.starchat.context.ChatContext;
import com.stardevllc.starchat.pm.PrivateMessage;
import com.stardevllc.starcore.actor.Actor;
import com.stardevllc.starcore.actor.PlayerActor;
import com.stardevllc.starcore.color.ColorUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class ReplyCmd
implements CommandExecutor {
    private StarChat plugin;

    public ReplyCmd(StarChat plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        PrivateMessage privateMessage;
        if (!sender.hasPermission("starchat.command.reply")) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)this.plugin.getMainConfig().getString("messages.command.nopermission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(ColorUtils.color((String)("&cUsage: /" + label + " <message>")));
            sender.sendMessage(ColorUtils.color((String)("&cUsage: /" + label + " <target> <message>")));
            return true;
        }
        Actor senderActor = Actor.create((Object)sender);
        Actor targetActor = Actor.create((Object)args[0]);
        if (targetActor != null) {
            privateMessage = this.plugin.getPrivateMessage(senderActor, targetActor);
            if (privateMessage == null) {
                sender.sendMessage(ColorUtils.color((String)("&cYou do not have a conversation open with " + targetActor.getName())));
                return true;
            }
            msgStart = 1;
        } else {
            if (senderActor instanceof PlayerActor) {
                PlayerActor playerActor = (PlayerActor)senderActor;
                privateMessage = this.plugin.getLastMessage(playerActor.getUniqueId());
            } else {
                privateMessage = this.plugin.getConsoleLastMessage();
            }
            if (privateMessage == null) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)"&cYou do not have any active conversations.");
                return true;
            }
            targetActor = privateMessage.getActor1().equals((Object)senderActor) ? privateMessage.getActor2() : privateMessage.getActor1();
            msgStart = 0;
        }
        StringBuilder msgBuilder = new StringBuilder();
        for (int i = msgStart; i < args.length; ++i) {
            msgBuilder.append(args[i]).append(" ");
        }
        privateMessage.sendMessage(new ChatContext(sender, msgBuilder.toString().trim()));
        this.plugin.assignLastMessage(sender, msgBuilder, privateMessage, senderActor, targetActor);
        return true;
    }
}

