/*
 * Decompiled with CFR 0.152.
 */
package com.stardevllc.starchat.commands;

import com.stardevllc.starchat.StarChat;
import com.stardevllc.starchat.channels.ChatChannel;
import com.stardevllc.starchat.placeholder.DefaultPlaceholders;
import com.stardevllc.starchat.placeholder.PAPIExpansion;
import com.stardevllc.starchat.placeholder.PAPIPlaceholders;
import com.stardevllc.starchat.pm.PrivateMessage;
import com.stardevllc.starchat.rooms.ChatRoom;
import com.stardevllc.starcore.actor.Actor;
import com.stardevllc.starcore.actor.PlayerActor;
import com.stardevllc.starcore.color.ColorUtils;
import com.stardevllc.starcore.utils.Config;
import com.stardevllc.starlib.converter.BooleanStringConverter;
import com.stardevllc.starlib.observable.property.writable.BooleanProperty;
import com.stardevllc.starlib.observable.property.writable.Property;
import com.stardevllc.starlib.observable.property.writable.StringProperty;
import com.stardevllc.starlib.reflection.ReflectionHelper;
import java.io.File;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class StarChatAdminCmd
implements CommandExecutor {
    private StarChat plugin;
    private Config pluginConfig;

    public StarChatAdminCmd(StarChat plugin) {
        this.plugin = plugin;
        this.pluginConfig = plugin.getMainConfig();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("starchat.command.admin")) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
            return true;
        }
        if (args.length <= 0) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)"&cYou must provide a sub-command.");
            return true;
        }
        if (args[0].equalsIgnoreCase("save")) {
            if (!sender.hasPermission("starchat.command.admin.save")) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                return true;
            }
            this.plugin.getMainConfig().save();
            ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.savesuccess"));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("starchat.command.admin.reload")) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                return true;
            }
            this.plugin.reload(false);
            ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.reloadsuccess"));
            return true;
        }
        if (args[0].equalsIgnoreCase("setconsolenameformat") || args[0].equalsIgnoreCase("setcnf")) {
            if (!sender.hasPermission("starchat.command.admin.setconsolenameformat")) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                return true;
            }
            if (args.length <= 1) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)"&cYou must provide a new console name.");
                return true;
            }
            StringBuilder sb = new StringBuilder();
            int i = 1;
            while (true) {
                if (i >= args.length) {
                    String consoleName = sb.toString().trim();
                    this.plugin.setConsoleNameFormat(consoleName);
                    ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.setconsolename").replace("{NEWNAME}", consoleName));
                    return true;
                }
                sb.append(args[i]).append(" ");
                ++i;
            }
        }
        if (args[0].equalsIgnoreCase("setprivatemessageformat") || args[0].equalsIgnoreCase("setpmf")) {
            if (!sender.hasPermission("starchat.command.admin.setprivatemessageformat")) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                return true;
            }
            if (args.length <= 1) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)"&cYou must provide a new private message format.");
                return true;
            }
            StringBuilder sb = new StringBuilder();
            int i = 1;
            while (true) {
                if (i >= args.length) {
                    String privateMessageFormat = sb.toString().trim();
                    this.plugin.setPrivateMessageFormat(privateMessageFormat);
                    sender.sendMessage(ColorUtils.color((String)"&aSet the new private message format to &r") + privateMessageFormat);
                    return true;
                }
                sb.append(args[i]).append(" ");
                ++i;
            }
        }
        if (args[0].equalsIgnoreCase("setuseplaceholderapi") || args[0].equalsIgnoreCase("setupapi")) {
            if (!sender.hasPermission("starchat.command.admin.setuseplaceholderapi")) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                return true;
            }
            if (args.length <= 1) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)"&cYou must provide a value");
                return true;
            }
            if (args[1].equalsIgnoreCase("true") || args[1].equalsIgnoreCase("yes")) {
                if (this.plugin.isUsePlaceholderAPI()) {
                    if (this.plugin.getPapiExpansion() != null && this.plugin.getPapiExpansion().isRegistered()) {
                        ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.setusepapi.alreadyconfigandenabled"));
                        return true;
                    }
                    Plugin papi = Bukkit.getPluginManager().getPlugin("PlaceholderAPI");
                    if (papi != null && papi.isEnabled()) {
                        this.plugin.setPapiExpansion(new PAPIExpansion(this.plugin));
                        this.plugin.getPapiExpansion().register();
                        this.plugin.setPlaceholderHandler(new PAPIPlaceholders());
                        ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.setusepapi.configbutnotenabled"));
                        return true;
                    }
                    ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.setusepapi.configbutnotdetected"));
                    return true;
                }
                Plugin papi = Bukkit.getPluginManager().getPlugin("PlaceholderAPI");
                if (papi != null && papi.isEnabled()) {
                    this.plugin.setPapiExpansion(new PAPIExpansion(this.plugin));
                    this.plugin.getPapiExpansion().register();
                    this.plugin.setPlaceholderHandler(new PAPIPlaceholders());
                    this.plugin.getMainConfig().set("use-placeholderapi", (Object)true);
                    this.plugin.setUsePlaceholderAPI(true);
                    ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.setusepapi.detectedandenabled"));
                    return true;
                }
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.setusepapi.notdetectednotenabled"));
                return true;
            }
            if (!args[1].equalsIgnoreCase("false") && !args[1].equalsIgnoreCase("no")) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)"&cYou must provide true, yes, false, or no.");
                return true;
            }
            if (this.plugin.getPapiExpansion() != null && this.plugin.getPapiExpansion().isRegistered()) {
                this.plugin.getPapiExpansion().unregister();
                this.plugin.setPapiExpansion(null);
                this.plugin.setPlaceholderHandler(new DefaultPlaceholders());
                this.plugin.getMainConfig().set("use-placeholderapi", (Object)false);
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.setusepapi.disabledsuccess"));
                return true;
            }
            ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.setuseapi.alreadydisabled"));
            return true;
        }
        if (args[0].equalsIgnoreCase("setusecolorpermissions") || args[0].equalsIgnoreCase("setucp")) {
            if (!sender.hasPermission("starchat.command.admin.setusecolorpermissions")) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                return true;
            }
            if (args.length <= 1) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)"&cYou must provide a value");
                return true;
            }
            if (args[1].equalsIgnoreCase("true") || args[1].equalsIgnoreCase("yes")) {
                if (this.plugin.isUseColorPermissions()) {
                    ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.setusecolorperms.alreadyenabled"));
                    return true;
                }
                this.plugin.setUseColorPermissions(true);
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.setusecolorperms.enabled"));
                return true;
            }
            if (!args[1].equalsIgnoreCase("false") && !args[1].equalsIgnoreCase("no")) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)"&cYou must provide true, yes, false, or no.");
                return true;
            }
            if (!this.plugin.isUseColorPermissions()) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.setusecolorperms.alreadydisabled"));
                return true;
            }
            this.plugin.setUseColorPermissions(false);
            ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.setusecolorperms.disabled"));
            return true;
        }
        if (args[0].equalsIgnoreCase("list")) {
            if (!sender.hasPermission("starchat.command.admin.list")) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                return true;
            }
            if (args.length <= 1) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)("&cUsage: /" + label + " list <all|channels|rooms|conversations>"));
                return true;
            }
            if (args[1].equalsIgnoreCase("all")) {
                if (!sender.hasPermission("starchat.command.admin.list.all")) {
                    ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                    return true;
                }
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.list.all.header"));
                if (sender.hasPermission("starchat.command.admin.list.channels")) {
                    this.listChannels(sender);
                }
                if (sender.hasPermission("starchat.command.admin.list.rooms")) {
                    this.listRooms(sender);
                }
                if (!sender.hasPermission("starchat.command.admin.list.conversations")) return true;
                this.listConversations(sender);
                return true;
            }
            if (args[1].equalsIgnoreCase("channels")) {
                if (!sender.hasPermission("starchat.command.admin.list.channels") && !sender.hasPermission("starchat.command.admin.list.all")) {
                    ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                    return true;
                }
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.list.channels.header"));
                this.listChannels(sender);
                return true;
            }
            if (args[1].equalsIgnoreCase("rooms")) {
                if (!sender.hasPermission("starchat.command.admin.list.rooms") && !sender.hasPermission("starchat.command.admin.list.all")) {
                    ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                    return true;
                }
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.list.rooms.header"));
                this.listRooms(sender);
                return true;
            }
            if (!args[1].equalsIgnoreCase("conversations")) return true;
            if (!sender.hasPermission("starchat.command.admin.list.conversations") && !sender.hasPermission("starchat.command.admin.list.all")) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                return true;
            }
            ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.list.conversations.header"));
            this.listConversations(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("setplayerchatfocus") || args[0].equalsIgnoreCase("setplayerfocus") || args[0].equalsIgnoreCase("setfocus")) {
            if (!sender.hasPermission("starchat.command.admin.setplayerchatfocus")) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                return true;
            }
            if (args.length <= 2) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)("&cUsage: /" + label + " " + args[0] + " <player> <chatspace>"));
                return true;
            }
            Actor target = Actor.create((Object)args[1]);
            if (target == null) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)"&cInvalid target, are they online?");
                return true;
            }
            if (!target.isPlayer()) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)"&cTarget must be a player.");
                return true;
            }
            if (!target.isOnline()) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)"&cTarget must be online to set the chat focus.");
                return true;
            }
            Player targetPlayer = ((PlayerActor)target).getPlayer();
            ChatChannel chatChannel = (ChatChannel)this.plugin.getChannelRegistry().get((Comparable)((Object)args[2]));
            if (chatChannel == null) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)"&cThat is not a valid channel.");
                return true;
            }
            this.plugin.setPlayerFocus(targetPlayer, chatChannel);
            ColorUtils.coloredMessage((CommandSender)sender, (String)("&eYou set &b" + targetPlayer.getName() + "'s &echat focus to &d" + chatChannel.getName()));
            ColorUtils.coloredMessage((CommandSender)targetPlayer, (String)("&eYour chat focus was changed to &d" + chatChannel.getName() + " &eby &b" + Actor.create((Object)sender).getName()));
            return true;
        }
        if (!args[0].equalsIgnoreCase("channel")) return true;
        if (!sender.hasPermission("starchat.command.admin.channel")) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
            return true;
        }
        if (args.length <= 2) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)("&cUsage: /" + label + " channel <[channelName]|create|delete> <args>"));
            return true;
        }
        if (args[1].equalsIgnoreCase("create")) {
            if (!sender.hasPermission("starchat.command.admin.channel.create")) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                return true;
            }
            StringBuilder sb = new StringBuilder();
            int i = 2;
            while (true) {
                if (i >= args.length) {
                    String channelName = sb.toString().trim();
                    File file = new File(this.plugin.getDataFolder() + File.separator + "channels" + File.separator + ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)channelName)).toLowerCase().replace(" ", "_") + ".yml");
                    ChatChannel chatChannel = new ChatChannel(this.plugin, channelName, file.toPath());
                    this.plugin.getChannelRegistry().register(chatChannel.getName(), chatChannel);
                    ColorUtils.coloredMessage((CommandSender)sender, (String)("&aCreated a new channel called " + channelName));
                    return true;
                }
                sb.append(args[i]).append(" ");
                ++i;
            }
        }
        ChatChannel chatChannel = (ChatChannel)this.plugin.getChannelRegistry().get((Comparable)((Object)args[1]));
        if (chatChannel == null) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)"&cThat is not a registered chat channel.");
            return true;
        }
        if (args[1].equalsIgnoreCase("delete")) {
            if (!sender.hasPermission("starchat.command.admin.channel.delete")) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
                return true;
            }
            if (!chatChannel.getPlugin().getName().equalsIgnoreCase(this.plugin.getName())) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)"&cYou can only delete chat channels owned by StarChat.");
                return true;
            }
            chatChannel.getFile().delete();
            this.plugin.getChannelRegistry().unregister(chatChannel.getName());
            ColorUtils.coloredMessage((CommandSender)sender, (String)("&eYou deleted the chat channel &b" + chatChannel.getName()));
        }
        if (!chatChannel.getPlugin().getName().equalsIgnoreCase(this.plugin.getName())) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)"&cYou can only modify chat channels owned by StarChat.");
            return true;
        }
        if (args.length <= 4) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)("&cUsage: /" + label + " " + args[0] + " " + args[1] + " <subcommand> <arguments>"));
            return true;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 4; i < args.length; ++i) {
            sb.append(args[i]).append(" ");
        }
        String value = sb.toString().trim();
        if (!args[2].equalsIgnoreCase("set")) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)"Invalid sub command.");
            return true;
        }
        Property property = (Property)ReflectionHelper.getProperty(Property.class, (Object)chatChannel, (String)args[3]);
        if (property == null) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)"You provided an invalid key name.");
            return true;
        }
        if (!sender.hasPermission("starchat.command.admin.channel.set." + property.getName().toLowerCase().replace(" ", "_"))) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.nopermission"));
            return true;
        }
        if (property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)property;
            stringProperty.set(value);
        } else {
            if (!(property instanceof BooleanProperty)) {
                ColorUtils.coloredMessage((CommandSender)sender, (String)"Unsupported Property Value Type, contact the developer to add support.");
                return true;
            }
            BooleanProperty booleanProperty = (BooleanProperty)property;
            booleanProperty.set(new BooleanStringConverter().fromString(value).booleanValue());
        }
        ColorUtils.coloredMessage((CommandSender)sender, (String)this.pluginConfig.getString("messages.command.admin.channel.set.success").replace("{channel}", chatChannel.getName()).replace("{key}", property.getName()).replace("{value}", "" + property.getValue()));
        chatChannel.saveConfig();
        return true;
    }

    private void listChannels(CommandSender sender) {
        Iterator iterator = this.plugin.getChannelRegistry().iterator();
        while (iterator.hasNext()) {
            ChatChannel chatChannel = (ChatChannel)iterator.next();
            ColorUtils.coloredMessage((CommandSender)sender, (String)(" &8- &eChannel &b" + chatChannel.getName() + " &eowned by the plugin &d" + chatChannel.getPlugin().getName()));
        }
    }

    private void listRooms(CommandSender sender) {
        Iterator iterator = this.plugin.getRoomRegistry().iterator();
        while (iterator.hasNext()) {
            ChatRoom chatRoom = (ChatRoom)iterator.next();
            ColorUtils.coloredMessage((CommandSender)sender, (String)(" &8- &eRoom &b" + chatRoom.getName() + " &eowned by the plugin &d" + chatRoom.getPlugin().getName()));
        }
    }

    private void listConversations(CommandSender sender) {
        for (PrivateMessage privateMessage : this.plugin.getPrivateMessages()) {
            ColorUtils.coloredMessage((CommandSender)sender, (String)(" &8- &eConversation between &b" + privateMessage.getActor1().getName() + " &end &b" + privateMessage.getActor2().getName()));
        }
    }
}

