/*
 * Decompiled with CFR 0.152.
 */
package com.stardevllc.starchat.context;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatContext {
    private final Source source;
    private CommandSender sender;
    private String message;
    private AsyncPlayerChatEvent chatEvent;

    public ChatContext(String message) {
        this.source = Source.DIRECT_NO_SENDER;
        this.message = message;
    }

    public ChatContext(CommandSender sender, String message) {
        this.source = Source.DIRECT_SENDER;
        this.sender = sender;
        this.message = message;
    }

    public ChatContext(AsyncPlayerChatEvent chatEvent) {
        this.source = Source.CHAT_EVENT;
        this.chatEvent = chatEvent;
    }

    public Source getSource() {
        return this.source;
    }

    public CommandSender getSender() {
        if (this.chatEvent != null) {
            return this.chatEvent.getPlayer();
        }
        return this.sender;
    }

    public String getMessage() {
        if (this.chatEvent != null) {
            return this.chatEvent.getMessage();
        }
        return this.message;
    }

    public AsyncPlayerChatEvent getChatEvent() {
        return this.chatEvent;
    }

    public Player getSenderAsPlayer() {
        CommandSender commandSender = this.getSender();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            return player;
        }
        return null;
    }

    public static enum Source {
        CHAT_EVENT,
        DIRECT_SENDER,
        DIRECT_NO_SENDER;

    }
}

