/*
 * Decompiled with CFR 0.152.
 */
package com.stardevllc.starchat.pm;

import com.stardevllc.starchat.ChatSelector;
import com.stardevllc.starchat.StarChat;
import com.stardevllc.starchat.pm.PrivateMessage;
import com.stardevllc.starcore.actor.Actor;
import com.stardevllc.starcore.actor.PlayerActor;
import com.stardevllc.starcore.color.ColorUtils;
import org.bukkit.entity.Player;

public class PrivateChatSelector
extends ChatSelector {
    public PrivateChatSelector() {
        super("private");
    }

    @Override
    public ChatSelector.ChatSelection getSelection(Player player, String[] args) {
        String nameOverride;
        PrivateMessage chatSpace;
        PlayerActor senderActor = new PlayerActor(player);
        if (args.length >= 2) {
            Actor targetActor = Actor.create((Object)args[1]);
            if (targetActor == null) {
                player.sendMessage(ColorUtils.color((String)"&cInvalid target."));
                return null;
            }
            chatSpace = StarChat.getInstance().getPrivateMessage((Actor)senderActor, targetActor);
            if (chatSpace == null) {
                player.sendMessage(ColorUtils.color((String)("You do not have a private conversation with " + targetActor.getName())));
                return null;
            }
            nameOverride = "Private (" + targetActor.getName() + ")";
        } else {
            PrivateMessage privateMessage = StarChat.getInstance().getLastMessage(player.getUniqueId());
            chatSpace = privateMessage;
            if (chatSpace == null) {
                player.sendMessage(ColorUtils.color((String)"&cYou do not have a last conversation to use as a focus."));
                return null;
            }
            Actor other = privateMessage.getActor1().equals((Object)senderActor) ? privateMessage.getActor2() : privateMessage.getActor1();
            nameOverride = "Private (" + other.getName() + ")";
        }
        return new ChatSelector.ChatSelection(chatSpace, nameOverride);
    }
}

