/*
 * Decompiled with CFR 0.152.
 */
package com.stardevllc.starchat.pm;

import com.stardevllc.starchat.context.ChatContext;
import com.stardevllc.starchat.space.ChatSpace;
import com.stardevllc.starcore.actor.Actor;
import com.stardevllc.starcore.color.ColorUtils;
import com.stardevllc.starlib.observable.property.writable.StringProperty;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PrivateMessage
implements ChatSpace {
    protected long id;
    protected JavaPlugin plugin;
    protected final StringProperty name;
    protected final StringProperty senderFormat;
    protected Function<Player, String> displayNameHandler;
    private Actor actor1;
    private Actor actor2;

    public PrivateMessage(JavaPlugin plugin, Actor actor1, Actor actor2, String format) {
        this.plugin = plugin;
        this.name = new StringProperty((Object)this, "name", "pm-" + actor1.getName() + "-" + actor2.getName());
        this.senderFormat = new StringProperty((Object)this, "senderFormat", format);
        this.actor1 = actor1;
        this.actor2 = actor2;
    }

    @Override
    public void sendMessage(ChatContext chatContext) {
        Actor targetActor;
        Actor senderActor;
        CommandSender sender = chatContext.getSender();
        String message = chatContext.getMessage();
        if (this.actor1.equals((Object)sender)) {
            senderActor = this.actor1;
            targetActor = this.actor2;
        } else if (this.actor2.equals((Object)sender)) {
            senderActor = this.actor2;
            targetActor = this.actor1;
        } else {
            sender.sendMessage(ColorUtils.color((String)"&cCould not determine if you are involved with that conversation."));
            return;
        }
        String format = this.senderFormat.get().replace("{message}", message);
        String senderMsg = format.replace("{from}", "me").replace("{to}", targetActor.getName());
        String targetMsg = format.replace("{from}", senderActor.getName()).replace("{to}", "me");
        senderActor.sendMessage(ColorUtils.color((String)senderMsg));
        targetActor.sendMessage(ColorUtils.color((String)targetMsg));
    }

    @Override
    public boolean canSendMessages(CommandSender sender) {
        Actor senderActor = Actor.create((Object)sender);
        return !senderActor.equals((Object)this.actor1) && !senderActor.equals((Object)this.actor2);
    }

    @Override
    public boolean canViewMessages(CommandSender sender) {
        return this.canSendMessages(sender);
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public Actor getActor1() {
        return this.actor1;
    }

    public Actor getActor2() {
        return this.actor2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PrivateMessage that = (PrivateMessage)object;
        if (!Objects.equals(this.actor1, that.actor1)) {
            return false;
        }
        return Objects.equals(this.actor2, that.actor2);
    }

    public int hashCode() {
        int result = this.actor1 != null ? this.actor1.hashCode() : 0;
        result = 31 * result + (this.actor2 != null ? this.actor2.hashCode() : 0);
        return result;
    }
}

