/*
 * Decompiled with CFR 0.152.
 */
package com.stardevllc.starchat.rooms;

import com.stardevllc.starchat.StarChat;
import com.stardevllc.starchat.context.ChatContext;
import com.stardevllc.starchat.rooms.DefaultPermissions;
import com.stardevllc.starchat.rooms.RoomMember;
import com.stardevllc.starchat.rooms.RoomPermission;
import com.stardevllc.starchat.space.ChatSpace;
import com.stardevllc.starcore.actor.Actor;
import com.stardevllc.starcore.color.ColorUtils;
import com.stardevllc.starlib.observable.property.writable.BooleanProperty;
import com.stardevllc.starlib.observable.property.writable.StringProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ChatRoom
implements ChatSpace {
    protected long id;
    protected JavaPlugin plugin;
    protected final StringProperty name;
    protected final BooleanProperty useColorPermissions;
    protected final StringProperty senderFormat;
    protected final StringProperty systemFormat;
    protected Function<Player, String> displayNameHandler;
    protected Actor owner;
    protected Map<UUID, RoomMember> members = new HashMap<UUID, RoomMember>();

    public ChatRoom(JavaPlugin plugin, Actor owner, String name) {
        this.plugin = plugin;
        this.owner = owner;
        this.name = new StringProperty((Object)this, "name", name);
        this.useColorPermissions = new BooleanProperty((Object)this, "useColorPermissions", false);
        this.senderFormat = new StringProperty((Object)this, "senderFormat", "");
        this.systemFormat = new StringProperty((Object)this, "systemFormat", "");
    }

    public ChatRoom(JavaPlugin plugin, String name) {
        this(plugin, (Actor)Actor.of((JavaPlugin)plugin), name);
    }

    @Override
    public void sendMessage(ChatContext context) {
        String format;
        Player player;
        String message;
        String displayName;
        if (context.getSender() == null) {
            displayName = "";
            message = ColorUtils.color((String)context.getMessage());
        } else {
            if (!this.canSendMessages(context.getSender())) {
                return;
            }
            CommandSender sender = context.getSender();
            if (context.getChatEvent() != null && context.getChatEvent().isCancelled() && !sender.hasPermission("starchat.room.bypass.cancelledevent")) {
                return;
            }
            message = context.getMessage();
            message = this.useColorPermissions.get() ? ColorUtils.color((CommandSender)context.getSender(), (String)message) : ColorUtils.color((String)message);
            if (context.getSender() instanceof ConsoleCommandSender) {
                displayName = StarChat.getInstance().getConsoleNameFormat();
            } else {
                player = (Player)context.getSender();
                displayName = Objects.requireNonNullElse(this.displayNameHandler, StarChat.vaultDisplayNameFunction).apply(player);
            }
        }
        if (context.getSender() == null) {
            format = ColorUtils.color((String)this.systemFormat.get().replace("{message}", message));
        } else {
            CommandSender commandSender = context.getSender();
            if (commandSender instanceof Player) {
                player = (Player)commandSender;
                format = ColorUtils.color((String)StarChat.getInstance().getPlaceholderHandler().setPlaceholders(player, this.senderFormat.get().replace("{displayname}", displayName))).replace("{message}", message);
            } else {
                format = ColorUtils.color((String)this.senderFormat.get().replace("{displayname}", displayName)).replace("{message}", message);
            }
        }
        for (UUID uuid : this.members.keySet()) {
            Player player2 = Bukkit.getPlayer((UUID)uuid);
            if (player2 == null || !this.canViewMessages((CommandSender)player2)) continue;
            player2.sendMessage(format);
        }
    }

    @Override
    public boolean canSendMessages(CommandSender sender) {
        Player player;
        RoomMember member;
        if (this.owner.equals((Object)sender)) {
            return true;
        }
        if (sender instanceof Player && (member = this.members.get((player = (Player)sender).getUniqueId())) != null) {
            return member.hasPermission(DefaultPermissions.SEND_MESSAGES);
        }
        return false;
    }

    @Override
    public boolean canViewMessages(CommandSender sender) {
        Player player;
        RoomMember member;
        if (this.owner.equals((Object)sender)) {
            return true;
        }
        if (sender instanceof Player && (member = this.members.get((player = (Player)sender).getUniqueId())) != null) {
            return member.hasPermission(DefaultPermissions.VIEW_MESSAGES);
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public boolean isOwner(UUID uuid) {
        if (this.owner.isPlayer()) {
            return this.owner.equals((Object)uuid);
        }
        return false;
    }

    public boolean isMember(UUID uuid) {
        if (this.isOwner(uuid)) {
            return true;
        }
        return this.members.containsKey(uuid);
    }

    public void changeOwner(Actor newOwner) {
        this.owner = newOwner;
    }

    public RoomMember addMember(UUID uniqueId, RoomPermission ... permissions) {
        RoomMember member = new RoomMember(uniqueId, permissions);
        this.members.put(uniqueId, member);
        return member;
    }

    public void removeMember(UUID member) {
        this.members.remove(member);
    }
}

