/*
 * Decompiled with CFR 0.152.
 */
package com.stardevllc.starchat.rooms;

import com.stardevllc.starchat.rooms.RoomPermission;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class RoomMember {
    private final UUID uniqueId;
    private Set<RoomPermission> permissions = new HashSet<RoomPermission>();

    public RoomMember(UUID uniqueId, RoomPermission ... permissions) {
        this.uniqueId = uniqueId;
        this.addPermission(permissions);
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uniqueId);
    }

    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    public Set<RoomPermission> getPermissions() {
        return new HashSet<RoomPermission>(this.permissions);
    }

    public void addPermission(RoomPermission ... permissions) {
        if (permissions != null) {
            this.permissions.addAll(List.of(permissions));
        }
    }

    public boolean hasPermission(RoomPermission permission) {
        return this.permissions.contains(permission);
    }
}

