/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.client.sound;

import dev.hephaestus.atmosfera.client.sound.modifiers.AtmosphericSoundModifier;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.BossBarCondition;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.DimensionEffectsModifier;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.PercentBiomeModifier;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.PercentBlockModifier;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.RidingCondition;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.SimpleBooleanCondition;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.SimpleBoundedCondition;
import java.util.HashMap;
import java.util.Map;

public final class AtmosphericSoundModifierRegistry {
    private static final Map<String, AtmosphericSoundModifier.FactoryDeserializer> FACTORIES = new HashMap<String, AtmosphericSoundModifier.FactoryDeserializer>();

    private AtmosphericSoundModifierRegistry() {
    }

    public static void register(AtmosphericSoundModifier.FactoryDeserializer factory, String type) {
        FACTORIES.putIfAbsent(type, factory);
    }

    public static AtmosphericSoundModifier.FactoryDeserializer get(String type) {
        return FACTORIES.get(type);
    }

    static {
        AtmosphericSoundModifierRegistry.register(SimpleBoundedCondition::altitude, "altitude");
        AtmosphericSoundModifierRegistry.register(SimpleBoundedCondition::elevation, "elevation");
        AtmosphericSoundModifierRegistry.register(SimpleBoundedCondition::skyVisibility, "sky_visibility");
        AtmosphericSoundModifierRegistry.register(SimpleBooleanCondition::isDaytime, "is_daytime");
        AtmosphericSoundModifierRegistry.register(SimpleBooleanCondition::isRainy, "is_rainy");
        AtmosphericSoundModifierRegistry.register(SimpleBooleanCondition::isStormy, "is_stormy");
        AtmosphericSoundModifierRegistry.register(PercentBlockModifier::create, "percent_block");
        AtmosphericSoundModifierRegistry.register(PercentBiomeModifier::create, "percent_biome");
        AtmosphericSoundModifierRegistry.register(RidingCondition::create, "riding");
        AtmosphericSoundModifierRegistry.register(DimensionEffectsModifier::create, "dimension_effects");
        AtmosphericSoundModifierRegistry.register(BossBarCondition::create, "boss_bar");
    }
}

