/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.client.sound;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.hephaestus.atmosfera.Atmosfera;
import dev.hephaestus.atmosfera.AtmosferaConfig;
import dev.hephaestus.atmosfera.client.sound.AtmosphericSoundDefinition;
import dev.hephaestus.atmosfera.client.sound.AtmosphericSoundModifierRegistry;
import dev.hephaestus.atmosfera.client.sound.modifiers.AtmosphericSoundModifier;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.ConfigModifier;
import dev.hephaestus.atmosfera.world.context.EnvironmentContext;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

public class SoundDefinitionsReloader
implements SimpleSynchronousResourceReloadListener {
    public class_2960 getFabricId() {
        return Atmosfera.id("sound_deserializer");
    }

    public void method_14491(class_3300 manager) {
        SoundDefinitionsReloader.loadSoundDefinitions(manager, "sounds/ambient", Atmosfera.SOUND_DEFINITIONS);
        SoundDefinitionsReloader.loadSoundDefinitions(manager, "sounds/music", Atmosfera.MUSIC_DEFINITIONS);
        AtmosferaConfig.loadedSoundDefinitions();
    }

    private static void loadSoundDefinitions(class_3300 manager, String sourceFolder, Map<class_2960, AtmosphericSoundDefinition> destination) {
        destination.clear();
        Map resources = manager.method_14488(sourceFolder + "/definitions", id -> id.method_12832().endsWith(".json"));
        for (class_2960 resource : resources.keySet()) {
            class_2960 id2 = class_2960.method_60655((String)resource.method_12836(), (String)resource.method_12832().substring(resource.method_12832().indexOf("definitions/") + "definitions/".length(), resource.method_12832().indexOf(".json")));
            try {
                BufferedReader reader = ((class_3298)resources.get(resource)).method_43039();
                try {
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    class_2960 soundId = class_2960.method_60654((String)class_3518.method_15265((JsonObject)json, (String)"sound"));
                    EnvironmentContext.Shape shape = SoundDefinitionsReloader.getShape(json, id2);
                    EnvironmentContext.Size size = SoundDefinitionsReloader.getSize(json, id2);
                    ImmutableCollection<AtmosphericSoundModifier.Factory> modifiers = SoundDefinitionsReloader.getModifiers(json, id2);
                    int defaultVolume = class_3518.method_15282((JsonObject)json, (String)"default_volume", (int)100);
                    boolean showSubtitlesByDefault = class_3518.method_15258((JsonObject)json, (String)"default_subtitle", (boolean)true);
                    destination.put(id2, new AtmosphericSoundDefinition(id2, soundId, shape, size, defaultVolume, showSubtitlesByDefault, modifiers));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                Atmosfera.error("Failed to load sound event '{}'", id2, e);
            }
        }
    }

    private static EnvironmentContext.Shape getShape(JsonObject json, class_2960 id) {
        if (json.has("shape")) {
            return EnvironmentContext.Shape.valueOf(json.getAsJsonPrimitive("shape").getAsString().toUpperCase(Locale.ROOT));
        }
        throw new RuntimeException("Sound definition '%s' is missing \"shape\" field.".formatted(id));
    }

    private static EnvironmentContext.Size getSize(JsonObject json, class_2960 id) {
        if (json.has("size")) {
            return json.has("size") ? EnvironmentContext.Size.valueOf(json.getAsJsonPrimitive("size").getAsString().toUpperCase(Locale.ROOT)) : EnvironmentContext.Size.MEDIUM;
        }
        throw new RuntimeException("Sound definition '%s' is missing \"size\" field.".formatted(id));
    }

    private static ImmutableCollection<AtmosphericSoundModifier.Factory> getModifiers(JsonObject json, class_2960 id) {
        ImmutableList.Builder modifiers = ImmutableList.builder();
        modifiers.add((Object)new ConfigModifier(id));
        if (json.has("modifiers")) {
            for (JsonElement element : json.get("modifiers").getAsJsonArray()) {
                JsonObject modifierJson = element.getAsJsonObject();
                if (!modifierJson.has("type")) {
                    throw new RuntimeException("Modifier for sound definition '%s' is missing \"type\" field.".formatted(id));
                }
                String type = modifierJson.get("type").getAsString();
                AtmosphericSoundModifier.FactoryDeserializer factory = AtmosphericSoundModifierRegistry.get(type);
                if (factory == null) {
                    Atmosfera.warn("Modifier type \"{}\" does not exist", type);
                    continue;
                }
                modifiers.add((Object)factory.deserialize(modifierJson));
            }
        }
        return modifiers.build();
    }
}

