/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.client.sound.modifiers;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

public class CommonAttributes {
    public static Bound getBound(JsonObject object) {
        float min = object.has("min") ? object.get("min").getAsFloat() : -3.4028235E38f;
        float max = object.has("max") ? object.get("max").getAsFloat() : Float.MAX_VALUE;
        return new Bound(min, max);
    }

    public static Range getRange(JsonObject object) {
        if (object.has("range")) {
            JsonArray array = object.getAsJsonArray("range");
            return new Range(array.get(0).getAsFloat(), array.get(1).getAsFloat());
        }
        return new Range(0.0f, 1.0f);
    }

    public record Bound(float min, float max) {
        public float apply(float x) {
            if (x < this.min) {
                return 0.0f;
            }
            if (x > this.max) {
                return 0.0f;
            }
            return x;
        }
    }

    public record Range(float lower, float upper) {
        public float apply(float x) {
            if (x >= this.upper) {
                return 1.0f;
            }
            if (x <= this.lower) {
                return 0.0f;
            }
            return (x - this.lower) / (this.upper - this.lower);
        }
    }
}

