/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.client.sound;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.hephaestus.atmosfera.Atmosfera;
import dev.hephaestus.atmosfera.client.sound.AtmosphericSoundDefinition;
import dev.hephaestus.atmosfera.client.sound.AtmosphericSoundModifierRegistry;
import dev.hephaestus.atmosfera.client.sound.modifiers.AtmosphericSoundModifier;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.ConfigModifier;
import dev.hephaestus.atmosfera.world.context.EnvironmentContext;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4013;

public record AtmosphericSoundSerializer(String sourceFolder, Map<class_2960, AtmosphericSoundDefinition> destination) implements class_4013
{
    public class_2960 getFabricId() {
        return Atmosfera.id(this.sourceFolder, new String[0]);
    }

    public void method_14491(class_3300 manager) {
        this.destination.clear();
        Map resources = manager.method_14488(this.sourceFolder + "/definitions", id -> id.method_12832().endsWith(".json"));
        for (class_2960 resource : resources.keySet()) {
            class_2960 id2 = class_2960.method_60655((String)resource.method_12836(), (String)resource.method_12832().substring(resource.method_12832().indexOf("definitions/") + 12, resource.method_12832().indexOf(".json")));
            try {
                JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(((class_3298)resources.get(resource)).method_14482())).getAsJsonObject();
                class_2960 soundId = class_2960.method_60654((String)class_3518.method_15265((JsonObject)json, (String)"sound"));
                EnvironmentContext.Shape shape = AtmosphericSoundSerializer.getShape(json, id2);
                EnvironmentContext.Size size = AtmosphericSoundSerializer.getSize(json, id2);
                ImmutableCollection<AtmosphericSoundModifier.Factory> modifiers = AtmosphericSoundSerializer.getModifiers(json, id2);
                int defaultVolume = this.getInteger(json, "default_volume", 100);
                boolean showSubtitlesByDefault = this.getBoolean(json, "show_subtitles_by_default", true);
                this.destination.put(id2, new AtmosphericSoundDefinition(id2, soundId, shape, size, defaultVolume, showSubtitlesByDefault, modifiers));
            }
            catch (Exception e) {
                Atmosfera.error("Failed to load sound event '{}'", id2, e);
            }
        }
    }

    private int getInteger(JsonObject json, String key, int ifAbsent) {
        JsonElement element = json.get(key);
        if (element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
            return element.getAsInt();
        }
        return ifAbsent;
    }

    private boolean getBoolean(JsonObject json, String key, boolean ifAbsent) {
        JsonElement element = json.get(key);
        if (element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
            return element.getAsBoolean();
        }
        return ifAbsent;
    }

    private static EnvironmentContext.Shape getShape(JsonObject json, class_2960 id) {
        if (json.has("shape")) {
            return EnvironmentContext.Shape.valueOf(json.getAsJsonPrimitive("shape").getAsString().toUpperCase(Locale.ROOT));
        }
        throw new RuntimeException(String.format("Sound definition '%s' is missing 'shape' field.", id));
    }

    private static EnvironmentContext.Size getSize(JsonObject json, class_2960 id) {
        if (json.has("size")) {
            return json.has("size") ? EnvironmentContext.Size.valueOf(json.getAsJsonPrimitive("size").getAsString().toUpperCase(Locale.ROOT)) : EnvironmentContext.Size.MEDIUM;
        }
        throw new RuntimeException(String.format("Sound definition '%s' is missing 'size' field.", id));
    }

    private static ImmutableCollection<AtmosphericSoundModifier.Factory> getModifiers(JsonObject json, class_2960 id) {
        ImmutableList.Builder modifiers = ImmutableList.builder();
        modifiers.add((Object)new ConfigModifier(id));
        if (json.has("modifiers")) {
            for (JsonElement element : json.get("modifiers").getAsJsonArray()) {
                if (!element.getAsJsonObject().has("type")) {
                    throw new RuntimeException(String.format("Modifier for sound definition '%s' is missing 'type' field.", id));
                }
                String type = element.getAsJsonObject().get("type").getAsString();
                AtmosphericSoundModifier.FactoryFactory factory = AtmosphericSoundModifierRegistry.get(type);
                if (factory == null) {
                    Atmosfera.log("Failed to create modifier of type '{}'", type);
                    continue;
                }
                modifiers.add((Object)factory.create(element.getAsJsonObject()));
            }
        }
        return modifiers.build();
    }
}

