/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.client.sound.modifiers.implementations;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.hephaestus.atmosfera.client.sound.modifiers.AtmosphericSoundModifier;
import dev.hephaestus.atmosfera.world.context.EnvironmentContext;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public record PercentBiomeModifier(float min, float max, ImmutableCollection<class_6880<class_1959>> biomes, ImmutableCollection<class_6862<class_1959>> biomeTags) implements AtmosphericSoundModifier
{
    public PercentBiomeModifier(float min, float max, ImmutableCollection<class_6880<class_1959>> biomes, ImmutableCollection<class_6862<class_1959>> biomeTags) {
        ImmutableList.Builder biomesBuilder = ImmutableList.builder();
        block0: for (class_6880 biomeEntry : biomes) {
            for (class_6862 tag : biomeTags) {
                if (!biomeEntry.method_40220(tag)) continue;
                continue block0;
            }
            biomesBuilder.add((Object)biomeEntry);
        }
        this.biomes = biomesBuilder.build();
        this.biomeTags = biomeTags;
        this.min = min;
        this.max = max;
    }

    @Override
    public float getModifier(EnvironmentContext context) {
        float modifier = 0.0f;
        for (class_6880 biomeEntry : this.biomes) {
            modifier += context.getBiomePercentage((class_1959)biomeEntry.comp_349());
        }
        for (class_6862 tag : this.biomeTags) {
            modifier += context.getBiomeTagPercentage((class_6862<class_1959>)tag);
        }
        return modifier >= this.min ? (modifier - this.min) * (1.0f / (this.max - this.min)) : 0.0f;
    }

    public static AtmosphericSoundModifier.Factory create(JsonObject object) {
        ImmutableList.Builder biomes = ImmutableList.builder();
        ImmutableList.Builder tags = ImmutableList.builder();
        class_3518.method_15261((JsonObject)object, (String)"biomes").forEach(arg_0 -> PercentBiomeModifier.lambda$create$0((ImmutableCollection.Builder)tags, (ImmutableCollection.Builder)biomes, arg_0));
        float min = 0.0f;
        float max = 1.0f;
        if (object.has("range")) {
            JsonArray array = object.getAsJsonArray("range");
            min = array.get(0).getAsFloat();
            max = array.get(1).getAsFloat();
        }
        return new Factory(min, max, (ImmutableCollection<class_2960>)biomes.build(), (ImmutableCollection<class_2960>)tags.build());
    }

    private static /* synthetic */ void lambda$create$0(ImmutableCollection.Builder tags, ImmutableCollection.Builder biomes, JsonElement biome) {
        if (biome.getAsString().startsWith("#")) {
            tags.add((Object)class_2960.method_60654((String)biome.getAsString().substring(1)));
        } else {
            class_2960 biomeID = class_2960.method_60654((String)biome.getAsString());
            biomes.add((Object)biomeID);
        }
    }

    private record Factory(float min, float max, ImmutableCollection<class_2960> biomes, ImmutableCollection<class_2960> biomeTags) implements AtmosphericSoundModifier.Factory
    {
        @Override
        public AtmosphericSoundModifier create(class_1937 world) {
            ImmutableList.Builder biomes = ImmutableList.builder();
            class_2378 biomeRegistry = world.method_30349().method_30530(class_7924.field_41236);
            for (class_2960 id : this.biomes) {
                class_1959 biome = (class_1959)biomeRegistry.method_63535(id);
                if (biome == null) continue;
                biomes.add((Object)biomeRegistry.method_47983((Object)biome));
            }
            ImmutableList.Builder tags = ImmutableList.builder();
            for (class_2960 id : this.biomeTags) {
                tags.add((Object)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)id));
            }
            return new PercentBiomeModifier(this.min, this.max, (ImmutableCollection<class_6880<class_1959>>)biomes.build(), (ImmutableCollection<class_6862<class_1959>>)tags.build());
        }
    }
}

