/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.client.sound.modifiers.implementations;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.hephaestus.atmosfera.client.sound.modifiers.AtmosphericSoundModifier;
import dev.hephaestus.atmosfera.world.context.EnvironmentContext;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_3518;

public record SimpleBoundedCondition(float min, float max, Function<EnvironmentContext, Number> valueGetter) implements AtmosphericSoundModifier,
AtmosphericSoundModifier.Factory
{
    @Override
    public float getModifier(EnvironmentContext context) {
        float value = this.valueGetter.apply(context).floatValue();
        return value > this.min && value <= this.max ? 1.0f : 0.0f;
    }

    @Override
    public AtmosphericSoundModifier create(class_1937 world) {
        return this;
    }

    public static SimpleBoundedCondition altitude(JsonElement element) {
        return SimpleBoundedCondition.create(element, EnvironmentContext::getAltitude);
    }

    public static SimpleBoundedCondition elevation(JsonElement element) {
        return SimpleBoundedCondition.create(element, EnvironmentContext::getElevation);
    }

    public static SimpleBoundedCondition skyVisibility(JsonElement element) {
        return SimpleBoundedCondition.create(element, EnvironmentContext::getSkyVisibility);
    }

    public static SimpleBoundedCondition create(JsonElement element, Function<EnvironmentContext, Number> valueGetter) {
        JsonObject object = element.getAsJsonObject();
        float min = object.has("lowerVolumeSlider") ? class_3518.method_15259((JsonObject)object, (String)"lowerVolumeSlider") : -3.4028235E38f;
        float max = object.has("upperVolumeSlider") ? class_3518.method_15259((JsonObject)object, (String)"upperVolumeSlider") : Float.MAX_VALUE;
        return new SimpleBoundedCondition(min, max, valueGetter);
    }
}

