/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.hephaestus.atmosfera.Atmosfera;
import dev.hephaestus.atmosfera.client.sound.AtmosphericSoundDefinition;
import java.io.IOException;
import java.lang.constant.Constable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class AtmosferaConfig {
    public static Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("atmosfera.json");
    private static final TreeMap<class_2960, Integer> VOLUME_MODIFIERS = new TreeMap(Comparator.comparing(id -> class_1074.method_4662((String)id.toString(), (Object[])new Object[0])));
    private static final TreeMap<class_2960, Boolean> SUBTITLE_MODIFIERS = new TreeMap(Comparator.comparing(id -> class_1074.method_4662((String)id.toString(), (Object[])new Object[0])));
    private static boolean printDebugMessages = false;
    private static boolean enableCustomMusic = true;
    private static float customMusicWeightScale = 2.5f;

    public static void read() throws IOException {
        JsonObject debug;
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            return;
        }
        String jsonString = Files.readString(CONFIG_PATH);
        JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
        if (json.has("general")) {
            JsonObject general = json.getAsJsonObject("general");
            if (general.has("enable_custom_music")) {
                enableCustomMusic = general.get("enable_custom_music").getAsBoolean();
            }
            if (general.has("custom_music_weight_scale")) {
                customMusicWeightScale = general.get("custom_music_weight_scale").getAsFloat();
            }
        }
        if (json.has("volumes")) {
            for (Map.Entry entry : json.get("volumes").getAsJsonObject().entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                VOLUME_MODIFIERS.put(new class_2960((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsInt());
            }
        }
        if (json.has("subtitles")) {
            for (Map.Entry entry : json.get("subtitles").getAsJsonObject().entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                SUBTITLE_MODIFIERS.put(new class_2960((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsBoolean());
            }
        }
        if (json.has("debug") && (debug = json.getAsJsonObject("debug")).has("print_debug_messages")) {
            printDebugMessages = debug.get("print_debug_messages").getAsBoolean();
        }
    }

    public static void loadedSoundDefinitions() {
        for (AtmosphericSoundDefinition sound : Atmosfera.SOUND_DEFINITIONS.values()) {
            VOLUME_MODIFIERS.putIfAbsent(sound.id(), sound.defaultVolume());
            SUBTITLE_MODIFIERS.putIfAbsent(sound.id(), sound.hasSubtitleByDefault());
        }
        for (AtmosphericSoundDefinition sound : Atmosfera.MUSIC_DEFINITIONS.values()) {
            VOLUME_MODIFIERS.putIfAbsent(sound.id(), sound.defaultVolume());
        }
        AtmosferaConfig.write();
    }

    public static String serialize() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject general = new JsonObject();
        general.addProperty("enable_custom_music", Boolean.valueOf(enableCustomMusic));
        general.addProperty("custom_music_weight_scale", (Number)Float.valueOf(customMusicWeightScale));
        JsonObject debug = new JsonObject();
        debug.addProperty("print_debug_messages", Boolean.valueOf(printDebugMessages));
        JsonObject config = new JsonObject();
        config.add("general", (JsonElement)general);
        config.add("volumes", gson.toJsonTree(VOLUME_MODIFIERS));
        config.add("subtitles", gson.toJsonTree(SUBTITLE_MODIFIERS));
        config.add("debug", (JsonElement)debug);
        return gson.toJson((JsonElement)config);
    }

    public static void write() {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)AtmosferaConfig.serialize(), new OpenOption[0]);
        }
        catch (Exception e) {
            Atmosfera.error("could not write config file!", e);
        }
    }

    public static float volumeModifier(class_2960 soundId) {
        return (float)VOLUME_MODIFIERS.getOrDefault(soundId, 100).intValue() / 100.0f;
    }

    public static boolean showSubtitle(class_2960 soundId) {
        return SUBTITLE_MODIFIERS.getOrDefault(soundId, true);
    }

    public static class_437 getScreen(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setTitle((class_2561)class_2561.method_43470((String)"Atmosfera"));
        builder.setParentScreen(parent);
        builder.setDefaultBackgroundTexture(new class_2960("minecraft:textures/block/light_blue_stained_glass.png"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder().setResetButtonKey((class_2561)class_2561.method_43471((String)"text.cloth-config.reset_value"));
        ConfigCategory generalCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"config.category.atmosfera.general"));
        ConfigCategory volumesCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"config.category.atmosfera.volumes"));
        ConfigCategory subtitlesCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"config.category.atmosfera.subtitles"));
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ConfigCategory debugCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"config.category.atmosfera.debug"));
            debugCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"config.value.atmosfera.print_debug_messages"), printDebugMessages).setSaveConsumer(b -> {
                printDebugMessages = b;
            }).setDefaultValue(false).build());
        }
        SubCategoryBuilder soundSubcategory = entryBuilder.startSubCategory((class_2561)class_2561.method_43471((String)"config.subcategory.atmosfera.ambient_sound")).setExpanded(true);
        SubCategoryBuilder musicSubcategory = entryBuilder.startSubCategory((class_2561)class_2561.method_43471((String)"config.subcategory.atmosfera.music")).setExpanded(true);
        generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"config.value.atmosfera.enable_custom_music"), enableCustomMusic).setTooltip(new class_2561[]{class_2561.method_43471((String)"config.value.atmosfera.enable_custom_music.@Tooltip")}).setSaveConsumer(b -> {
            enableCustomMusic = b;
        }).setDefaultValue(true).build());
        generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startLongSlider((class_2561)class_2561.method_43471((String)"config.value.atmosfera.custom_music_weight_scale"), (long)(customMusicWeightScale * 100.0f), 1L, 1000L).setSaveConsumer(v -> {
            customMusicWeightScale = (float)v.longValue() / 100.0f;
        }).setTextGetter(v -> class_2561.method_43470((String)(v + "%"))).setDefaultValue(250L).build());
        generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"config.value.atmosfera.custom_music_weight_scale_explanation")).setTooltip(new class_2561[]{class_2561.method_43471((String)"config.value.atmosfera.custom_music_weight_scale_explanation.@Tooltip")}).build());
        for (Map.Entry<class_2960, Integer> entry : VOLUME_MODIFIERS.entrySet()) {
            class_5250 tooltip;
            String soundLangID;
            Map<class_2960, AtmosphericSoundDefinition> soundType;
            if (Atmosfera.SOUND_DEFINITIONS.containsKey(entry.getKey())) {
                soundType = Atmosfera.SOUND_DEFINITIONS;
                if (!soundType.containsKey(entry.getKey())) continue;
                soundLangID = String.join((CharSequence)".", entry.getKey().toString().split(":"));
                tooltip = class_2561.method_43470((String)(soundLangID + "\n"));
                tooltip.method_10852((class_2561)class_2561.method_43471((String)("subtitle." + soundLangID)));
                tooltip.method_27693("\n");
                tooltip.method_10852((class_2561)class_2561.method_43471((String)"config.value.atmosfera.sound_tip.@Tooltip"));
                soundSubcategory.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43471((String)soundLangID), entry.getValue().intValue(), 0, 200).setDefaultValue(soundType.get(entry.getKey()).defaultVolume()).setTooltip(new class_2561[]{tooltip.method_27692(class_124.field_1080)}).setTextGetter(integer -> class_2561.method_43470((String)(integer + "%"))).setSaveConsumer(volume -> VOLUME_MODIFIERS.put((class_2960)sound.getKey(), (Integer)volume)).build());
                continue;
            }
            soundType = Atmosfera.MUSIC_DEFINITIONS;
            if (!soundType.containsKey(entry.getKey())) continue;
            soundLangID = String.join((CharSequence)".", entry.getKey().toString().split(":"));
            tooltip = class_2561.method_43470((String)soundLangID);
            tooltip.method_27693("\n");
            tooltip.method_10852((class_2561)class_2561.method_43471((String)"config.value.atmosfera.sound_tip.@Tooltip"));
            musicSubcategory.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43471((String)soundLangID), entry.getValue().intValue(), 0, 200).setDefaultValue(soundType.get(entry.getKey()).defaultVolume()).setTooltip(new class_2561[]{tooltip.method_27692(class_124.field_1080)}).setTextGetter(integer -> class_2561.method_43470((String)(integer + "%"))).setSaveConsumer(volume -> VOLUME_MODIFIERS.put((class_2960)sound.getKey(), (Integer)volume)).build());
        }
        volumesCategory.addEntry((AbstractConfigListEntry)soundSubcategory.build());
        volumesCategory.addEntry((AbstractConfigListEntry)musicSubcategory.build());
        for (Map.Entry<class_2960, Constable> entry : SUBTITLE_MODIFIERS.entrySet()) {
            if (!Atmosfera.SOUND_DEFINITIONS.containsKey(entry.getKey())) continue;
            String soundLangID = String.join((CharSequence)".", entry.getKey().toString().split(":"));
            class_5250 tooltipText = class_2561.method_43470((String)(soundLangID + "\n"));
            tooltipText.method_10852((class_2561)class_2561.method_43471((String)("subtitle." + soundLangID)));
            subtitlesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)soundLangID), ((Boolean)entry.getValue()).booleanValue()).setDefaultValue(Atmosfera.SOUND_DEFINITIONS.get(entry.getKey()).hasSubtitleByDefault()).setTooltip(new class_2561[]{tooltipText.method_27692(class_124.field_1080)}).setSaveConsumer(subtitle -> SUBTITLE_MODIFIERS.put((class_2960)sound.getKey(), (Boolean)subtitle)).build());
        }
        if (soundSubcategory.size() + musicSubcategory.size() == 0) {
            subtitlesCategory.removeCategory();
            volumesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"config.atmosfera.resource_pack_warning").method_27692(class_124.field_1061)).build());
        }
        builder.setSavingRunnable(AtmosferaConfig::write);
        return builder.build();
    }

    public static boolean printDebugMessages() {
        return printDebugMessages;
    }

    public static boolean enableCustomMusic() {
        return enableCustomMusic;
    }

    public static float customMusicWeightScale() {
        return customMusicWeightScale;
    }

    static {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            AtmosferaConfig.write();
        } else {
            try {
                AtmosferaConfig.read();
            }
            catch (Exception e) {
                Atmosfera.error("failed to read config! overwriting with default config...", e);
                AtmosferaConfig.write();
            }
        }
    }
}

