/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.client.sound;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import dev.hephaestus.atmosfera.Atmosfera;
import dev.hephaestus.atmosfera.AtmosferaConfig;
import dev.hephaestus.atmosfera.client.sound.AtmosphericSound;
import dev.hephaestus.atmosfera.client.sound.AtmosphericSoundDefinition;
import dev.hephaestus.atmosfera.client.sound.AtmosphericSoundInstance;
import dev.hephaestus.atmosfera.client.sound.modifiers.AtmosphericSoundModifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1117;
import net.minecraft.class_1143;
import net.minecraft.class_1144;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_5195;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;

public class AtmosphericSoundHandler {
    private static final class_5819 RANDOM = class_5819.method_43047();
    private static final Map<AtmosphericSound, class_5195> MUSIC = new HashMap<AtmosphericSound, class_5195>();
    private final ImmutableList<AtmosphericSound> sounds;
    private final ImmutableList<AtmosphericSound> musics;
    private final Map<AtmosphericSound, AtmosphericSoundInstance> playingSounds = new HashMap<AtmosphericSound, AtmosphericSoundInstance>();

    public AtmosphericSoundHandler(class_638 world) {
        this.sounds = AtmosphericSoundHandler.getSoundsFromDefinitions(Atmosfera.SOUND_DEFINITIONS, world);
        this.musics = AtmosphericSoundHandler.getSoundsFromDefinitions(Atmosfera.MUSIC_DEFINITIONS, world);
    }

    private static ImmutableList<AtmosphericSound> getSoundsFromDefinitions(Map<class_2960, AtmosphericSoundDefinition> definitions, class_638 world) {
        ImmutableList.Builder sounds = ImmutableList.builder();
        for (AtmosphericSoundDefinition definition : definitions.values()) {
            ImmutableList.Builder modifiers = ImmutableList.builder();
            for (AtmosphericSoundModifier.Factory factory : definition.modifierFactories()) {
                modifiers.add((Object)factory.create((class_1937)world));
            }
            sounds.add((Object)new AtmosphericSound(definition.id(), definition.soundId(), definition.shape(), definition.size(), (ImmutableCollection<AtmosphericSoundModifier>)modifiers.build()));
        }
        return sounds.build();
    }

    public void tick() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        world.atmosfera$updateEnvironmentContext();
        this.playingSounds.values().removeIf(AtmosphericSoundInstance::method_4793);
        for (AtmosphericSound sound : this.sounds) {
            float volume;
            if (this.playingSounds.containsKey(sound) || !((double)(volume = sound.getVolume(world)) >= 0.0125) || !(client.field_1690.method_1630(class_3419.field_15256) > 0.0f)) continue;
            AtmosphericSoundInstance soundInstance = new AtmosphericSoundInstance(sound, 1.0E-4f);
            this.playingSounds.put(sound, soundInstance);
            client.method_1483().method_22140((class_1117)soundInstance);
            Atmosfera.debug("volume > 0: {} - {}", sound.id(), Float.valueOf(volume));
        }
    }

    public class_5195 getMusicSound(class_5195 original) {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null || !world.atmosfera$isEnvironmentContextInitialized() || client.field_1690.method_1630(class_3419.field_15253) == 0.0f) {
            return original;
        }
        class_1144 soundManager = client.method_1483();
        float originalWeight = soundManager.method_4869(((class_3414)original.method_27279().comp_349()).method_14833()).method_4894();
        ArrayList<class_3545> candidates = new ArrayList<class_3545>();
        float total = 0.0f;
        candidates.add(new class_3545((Object)Float.valueOf(originalWeight), (Object)original));
        total += originalWeight;
        for (AtmosphericSound music : this.musics) {
            float volume = music.getVolume(world);
            if (!((double)volume >= 0.0125)) continue;
            float weight = AtmosferaConfig.customMusicWeightScale() * (float)soundManager.method_4869(music.soundId()).method_4894();
            candidates.add(new class_3545((Object)Float.valueOf(weight), (Object)MUSIC.computeIfAbsent(music, id -> {
                Atmosfera.debug("createIngameMusic: {}", music.id());
                return class_1143.method_27283((class_6880)class_6880.method_40223((Object)class_3414.method_47908((class_2960)music.soundId())));
            })));
            total += weight;
        }
        float i = total <= 0.0f ? 0.0f : RANDOM.method_43057() * total;
        for (class_3545 pair : candidates) {
            if (!((i -= ((Float)pair.method_15442()).floatValue()) < 0.0f)) continue;
            return (class_5195)pair.method_15441();
        }
        return (class_5195)((class_3545)candidates.get(candidates.size() - 1)).method_15441();
    }
}

