/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.client.sound.modifiers.implementations;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import dev.hephaestus.atmosfera.client.sound.modifiers.AtmosphericSoundModifier;
import dev.hephaestus.atmosfera.client.sound.modifiers.CommonAttributes;
import dev.hephaestus.atmosfera.world.context.EnvironmentContext;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public record PercentBlockModifier(CommonAttributes.Range range, CommonAttributes.Bound bound, ImmutableCollection<class_2248> blocks, ImmutableCollection<class_6862<class_2248>> blockTags) implements AtmosphericSoundModifier,
AtmosphericSoundModifier.Factory
{
    public PercentBlockModifier(CommonAttributes.Range range, CommonAttributes.Bound bound, ImmutableCollection<class_2248> blocks, ImmutableCollection<class_6862<class_2248>> blockTags) {
        ImmutableList.Builder blocksBuilder = ImmutableList.builder();
        block0: for (class_2248 block : blocks) {
            for (class_6862 tag : blockTags) {
                if (!block.method_9564().method_26164(tag)) continue;
                continue block0;
            }
            blocksBuilder.add((Object)block);
        }
        this.blocks = blocksBuilder.build();
        this.blockTags = blockTags;
        this.range = range;
        this.bound = bound;
    }

    @Override
    public float getModifier(EnvironmentContext context) {
        float modifier = 0.0f;
        for (class_2248 block : this.blocks) {
            modifier += context.getBlockTypePercentage(block);
        }
        for (class_6862 tag : this.blockTags) {
            modifier += context.getBlockTagPercentage((class_6862<class_2248>)tag);
        }
        return this.range.apply(this.bound.apply(modifier));
    }

    public static PercentBlockModifier create(JsonObject object) {
        ImmutableList.Builder blocks = ImmutableList.builder();
        ImmutableList.Builder tags = ImmutableList.builder();
        class_3518.method_15261((JsonObject)object, (String)"blocks").forEach(block -> {
            if (block.getAsString().startsWith("#")) {
                class_2960 tagId = new class_2960(block.getAsString().substring(1));
                tags.add((Object)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)tagId));
            } else {
                class_2960 blockId = new class_2960(block.getAsString());
                if (class_7923.field_41175.method_10250(blockId)) {
                    class_2248 b = (class_2248)class_7923.field_41175.method_10223(blockId);
                    blocks.add((Object)b);
                }
            }
        });
        CommonAttributes.Range range = CommonAttributes.getRange(object);
        CommonAttributes.Bound bound = CommonAttributes.getBound(object);
        return new PercentBlockModifier(range, bound, (ImmutableCollection<class_2248>)blocks.build(), (ImmutableCollection<class_6862<class_2248>>)tags.build());
    }

    @Override
    public AtmosphericSoundModifier create(class_1937 world) {
        return this;
    }
}

