/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.client.sound.modifiers.implementations;

import com.google.gson.JsonObject;
import dev.hephaestus.atmosfera.client.sound.modifiers.AtmosphericSoundModifier;
import dev.hephaestus.atmosfera.client.sound.modifiers.CommonAttributes;
import dev.hephaestus.atmosfera.world.context.EnvironmentContext;
import java.util.function.Function;
import net.minecraft.class_1937;

public record SimpleBoundedCondition(CommonAttributes.Range range, CommonAttributes.Bound bound, Function<EnvironmentContext, Number> valueGetter) implements AtmosphericSoundModifier,
AtmosphericSoundModifier.Factory
{
    @Override
    public float getModifier(EnvironmentContext context) {
        float value = this.valueGetter.apply(context).floatValue();
        return this.range.apply(this.bound.apply(value));
    }

    @Override
    public AtmosphericSoundModifier create(class_1937 world) {
        return this;
    }

    public static SimpleBoundedCondition altitude(JsonObject object) {
        return SimpleBoundedCondition.create(object, EnvironmentContext::getAltitude);
    }

    public static SimpleBoundedCondition elevation(JsonObject object) {
        return SimpleBoundedCondition.create(object, EnvironmentContext::getElevation);
    }

    public static SimpleBoundedCondition skyVisibility(JsonObject object) {
        return SimpleBoundedCondition.create(object, EnvironmentContext::getSkyVisibility);
    }

    public static SimpleBoundedCondition create(JsonObject object, Function<EnvironmentContext, Number> valueGetter) {
        CommonAttributes.Range range = CommonAttributes.getRange(object);
        CommonAttributes.Bound bound = CommonAttributes.getBound(object);
        return new SimpleBoundedCondition(range, bound, valueGetter);
    }
}

