/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.world.context;

import dev.hephaestus.atmosfera.world.context.EnvironmentContext;
import dev.hephaestus.atmosfera.world.context.Sphere;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_746;

class Hemisphere
implements EnvironmentContext {
    private final byte[][] offsets;
    private final Sphere sphere;
    private final Map<class_2248, Integer> blockTypes = new ConcurrentHashMap<class_2248, Integer>();
    private final Map<class_2960, Integer> blockTags = new ConcurrentHashMap<class_2960, Integer>();
    private final Map<class_1959, Integer> biomeTypes = new ConcurrentHashMap<class_1959, Integer>();
    private final Map<class_2960, Integer> biomeTags = new ConcurrentHashMap<class_2960, Integer>();
    private final AtomicInteger blockCount = new AtomicInteger();
    private final AtomicInteger skyVisibility = new AtomicInteger();

    Hemisphere(byte[][] offsets, Sphere sphere) {
        this.sphere = sphere;
        this.offsets = offsets;
    }

    @Override
    public class_746 getPlayer() {
        return this.sphere.player;
    }

    @Override
    public float getBlockTypePercentage(class_2248 block) {
        return (float)this.blockTypes.getOrDefault(block, 0).intValue() / (float)this.blockCount.get();
    }

    @Override
    public float getBlockTagPercentage(class_6862<class_2248> blocks) {
        return (float)this.blockTags.getOrDefault(blocks.comp_327(), 0).intValue() / (float)this.blockCount.get();
    }

    @Override
    public float getBiomePercentage(class_1959 biome) {
        return (float)this.biomeTypes.getOrDefault(biome, 0).intValue() / (float)this.blockCount.get();
    }

    @Override
    public float getBiomeTagPercentage(class_6862<class_1959> biomes) {
        return (float)this.biomeTags.getOrDefault(biomes.comp_327(), 0).intValue() / (float)this.blockCount.get();
    }

    @Override
    public float getAltitude() {
        return this.sphere.altitude;
    }

    @Override
    public float getElevation() {
        return this.sphere.elevation;
    }

    @Override
    public float getSkyVisibility() {
        return (float)this.skyVisibility.get() / (float)this.blockCount.get();
    }

    @Override
    public boolean isDaytime() {
        return this.sphere.isDay;
    }

    @Override
    public boolean isRainy() {
        return this.sphere.isRainy;
    }

    @Override
    public boolean isStormy() {
        return this.sphere.isStormy;
    }

    @Override
    public class_1297 getVehicle() {
        return this.sphere.vehicle;
    }

    @Override
    public Collection<String> getBossBars() {
        return this.sphere.bossBars;
    }

    private void clear() {
        this.blockCount.set(0);
        this.skyVisibility.set(0);
        this.blockTypes.replaceAll((block, integer) -> 0);
        this.blockTags.replaceAll((identifier, integer) -> 0);
        this.biomeTypes.replaceAll((biome, integer) -> 0);
        this.blockTags.replaceAll((identifier, integer) -> 0);
    }

    private void add(class_1937 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        this.blockTypes.merge(block, 1, Integer::sum);
        block.method_40142().method_40228().forEach(blockTag -> this.blockTags.merge(blockTag.comp_327(), 1, Integer::sum));
        class_6880 biomeEntry = world.method_23753(pos);
        class_1959 biome = (class_1959)biomeEntry.comp_349();
        biomeEntry.method_40228().forEach(biomeTag -> this.biomeTags.merge(biomeTag.comp_327(), 1, Integer::sum));
        this.biomeTypes.merge(biome, 1, Integer::sum);
        this.skyVisibility.addAndGet(world.method_8314(class_1944.field_9284, pos) / 15);
        this.blockCount.incrementAndGet();
    }

    void update(class_2338 center) {
        this.clear();
        class_2338.class_2339 mut = new class_2338.class_2339();
        class_1937 world = this.getPlayer().method_73183();
        for (byte[] a : this.offsets) {
            mut.method_10103(center.method_10263() + a[0], center.method_10264() + a[1], center.method_10260() + a[2]);
            this.add(world, (class_2338)mut);
        }
    }
}

