/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.world.context;

import dev.hephaestus.atmosfera.mixin.BossBarHudAccessor;
import dev.hephaestus.atmosfera.world.context.AbstractEnvironmentContext;
import dev.hephaestus.atmosfera.world.context.ContextUtil;
import dev.hephaestus.atmosfera.world.context.EnvironmentContext;
import dev.hephaestus.atmosfera.world.context.Hemisphere;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_337;
import net.minecraft.class_345;
import net.minecraft.class_6862;
import net.minecraft.class_7417;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class Sphere
extends AbstractEnvironmentContext {
    final Hemisphere upperHemisphere;
    final Hemisphere lowerHemisphere;

    public Sphere(EnvironmentContext.Size size, class_746 player) {
        super(player);
        this.upperHemisphere = new Hemisphere(ContextUtil.OFFSETS[EnvironmentContext.Shape.UPPER_HEMISPHERE.ordinal()][size.ordinal()], this);
        this.lowerHemisphere = new Hemisphere(ContextUtil.OFFSETS[EnvironmentContext.Shape.LOWER_HEMISPHERE.ordinal()][size.ordinal()], this);
        this.bossBars = new HashSet();
    }

    @Override
    public float getBlockTypePercentage(class_2248 block) {
        return (this.upperHemisphere.getBlockTypePercentage(block) + this.lowerHemisphere.getBlockTypePercentage(block)) / 2.0f;
    }

    @Override
    public float getBlockTagPercentage(class_6862<class_2248> blocks) {
        return (this.upperHemisphere.getBlockTagPercentage(blocks) + this.lowerHemisphere.getBlockTagPercentage(blocks)) / 2.0f;
    }

    @Override
    public float getBiomePercentage(class_1959 biome) {
        return (this.upperHemisphere.getBiomePercentage(biome) + this.lowerHemisphere.getBiomePercentage(biome)) / 2.0f;
    }

    @Override
    public float getBiomeTagPercentage(class_6862<class_1959> biomes) {
        return (this.upperHemisphere.getBiomeTagPercentage(biomes) + this.lowerHemisphere.getBiomeTagPercentage(biomes)) / 2.0f;
    }

    @Override
    public float getSkyVisibility() {
        return (this.upperHemisphere.getSkyVisibility() + this.lowerHemisphere.getSkyVisibility()) / 2.0f;
    }

    public void update() {
        class_2338 pos;
        class_1937 world = this.getPlayer().method_73183();
        if (world.method_8393((pos = this.getPlayer().method_24515()).method_10263() >> 4, pos.method_10260() << 4)) {
            class_2338.class_2339 mut = new class_2338.class_2339().method_10101((class_2382)pos);
            int count = 0;
            while (world.method_8320((class_2338)mut).method_26215() && mut.method_10264() > 0) {
                ++count;
                mut.method_10098(class_2350.field_11033);
            }
            this.altitude = count;
            this.bossBars.clear();
            class_337 bossBarHud = class_310.method_1551().field_1705.method_1740();
            Map<UUID, class_345> bossBarMap = ((BossBarHudAccessor)bossBarHud).getBossBars();
            for (class_345 bossBar : bossBarMap.values()) {
                String string;
                class_7417 class_74172 = bossBar.method_5414().method_10851();
                if (class_74172 instanceof class_2588) {
                    class_2588 translatable = (class_2588)class_74172;
                    string = translatable.method_11022();
                } else {
                    string = bossBar.method_5414().toString();
                }
                String value = string;
                this.bossBars.add(value);
            }
            this.elevation = pos.method_10264();
            this.isDay = world.method_8530();
            this.isRainy = world.method_8419();
            this.isStormy = world.method_8546();
            this.vehicle = this.getPlayer().method_5854();
            ContextUtil.EXECUTOR.execute(() -> this.upperHemisphere.update(pos.method_10084()));
            ContextUtil.EXECUTOR.execute(() -> this.lowerHemisphere.update(pos.method_10074()));
        }
    }

    public EnvironmentContext getUpperHemisphere() {
        return this.upperHemisphere;
    }

    public EnvironmentContext getLowerHemisphere() {
        return this.lowerHemisphere;
    }
}

