/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.slime;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.lunade.slime.LunaSlimes;
import net.lunade.slime.config.getter.LunaSlimesConfigValueGetter;
import net.lunade.slime.impl.SlimeInterface;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1621;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_5819;

public class LunaSlimesUtil {
    public static void mergeSlimes(class_1621 slime1, class_1621 slime2) {
        boolean verticalCollision;
        SlimeInterface slimeInterface1;
        class_1299 entityType;
        block16: {
            block15: {
                entityType = slime1.method_5864();
                if (slime2.method_5864() != entityType || !slime1.method_5805() || !slime2.method_5805()) {
                    return;
                }
                if (!(slime1 instanceof SlimeInterface)) break block15;
                slimeInterface1 = (SlimeInterface)slime1;
                if (slime2 instanceof SlimeInterface) break block16;
            }
            return;
        }
        SlimeInterface slimeInterface2 = (SlimeInterface)slime2;
        int thisSize = slime1.method_7152();
        int otherSize = slime2.method_7152();
        if (thisSize < otherSize && thisSize != otherSize) {
            return;
        }
        if (thisSize > LunaSlimesConfigValueGetter.maxSize() - 1) {
            return;
        }
        if (thisSize > LunaSlimesConfigValueGetter.maxSize() - 1) {
            return;
        }
        if (slimeInterface1.lunaSlimes$getMergeCooldown() > 0) {
            return;
        }
        if (slimeInterface2.lunaSlimes$getMergeCooldown() > 0) {
            return;
        }
        class_4048 oldDimensions = LunaSlimesUtil.getDimensionsForSize(slime1, thisSize);
        class_4048 inflated = LunaSlimesUtil.getDimensionsForSize(slime1, thisSize + 1);
        class_243 newPos = slime1.method_73189().method_1031(0.0, (double)((inflated.comp_2186() - oldDimensions.comp_2186()) * 0.5f), 0.0);
        class_243 deltaMovement = slime1.method_18798();
        class_243 vec32 = LunaSlimesUtil.collideWithBox(slime1, deltaMovement, inflated.method_30757(newPos));
        boolean horizontalCollision = !class_3532.method_20390((double)deltaMovement.field_1352, (double)vec32.field_1352) || !class_3532.method_20390((double)deltaMovement.field_1350, (double)vec32.field_1350);
        boolean bl = verticalCollision = deltaMovement.field_1351 != vec32.field_1351;
        if (horizontalCollision || verticalCollision) {
            return;
        }
        slime1.method_7161(thisSize + 1, true);
        slimeInterface1.lunaSlimes$setMergeCooldown(LunaSlimesConfigValueGetter.mergeCooldown());
        slimeInterface1.lunaSlimes$playWobbleAnim();
        if (LunaSlimesConfigValueGetter.mergeSounds()) {
            class_5819 random = slime1.method_59922();
            slime1.method_5783(entityType == class_1299.field_6102 ? LunaSlimes.MAGMA_MERGE : LunaSlimes.SLIME_MERGE, slime1.method_6107(), 1.0f + (random.method_43057() - random.method_43057()) * 0.4f);
        }
        slimeInterface2.lunaSlimes$playWobbleAnim();
        if (slime2.method_5947()) {
            slime1.method_5971();
        }
        if (slime2.method_16914() && !slime1.method_16914()) {
            slime1.method_5665(slime2.method_5797());
        }
        slime1.method_5684(slime2.method_5655());
        slime1.method_5803(slime2.method_5701());
        slime1.method_20803((int)Math.max((double)slime1.method_20802(), (double)slime2.method_20802() * 0.5));
        slime1.method_32317((int)Math.max((double)slime1.method_32312(), (double)slime2.method_32312() * 0.5));
        slime1.method_33574(newPos);
        if (otherSize - 1 <= 0) {
            slime2.method_31472();
        } else {
            slime2.method_7161(otherSize - 1, true);
        }
    }

    public static int spawnSingleSlime(class_1621 origin) {
        int originalSize = origin.method_7152();
        if (origin.method_73183().method_8608() || originalSize <= 0) {
            return 0;
        }
        if (!(origin instanceof SlimeInterface)) {
            return 0;
        }
        SlimeInterface originInterface = (SlimeInterface)origin;
        int splitOff = 0;
        class_5819 random = origin.method_59922();
        class_2561 customName = origin.method_5797();
        class_1299 entityType = origin.method_5864();
        class_1621 slime = (class_1621)entityType.method_5883(origin.method_73183(), class_3730.field_16461);
        if (!(slime instanceof SlimeInterface)) {
            return splitOff;
        }
        SlimeInterface slimeInterface = (SlimeInterface)slime;
        float quarterSize = (float)originalSize / 4.0f;
        int posRandom = (int)((double)(2 + random.method_43048(3)) * random.method_43058());
        float xRandom = ((float)(posRandom % 2) - 0.5f) * quarterSize;
        float zRandom = ((float)(posRandom / 2) - 0.5f) * quarterSize;
        slime.method_5808(origin.method_23317() + (double)xRandom, origin.method_23318() + 0.5, origin.method_23321() + (double)zRandom, random.method_43057() * 360.0f, 0.0f);
        if (origin.method_5947()) {
            slime.method_5971();
        }
        slime.method_5665(customName);
        slime.method_5977(origin.method_5987());
        slime.method_5684(origin.method_5655());
        slime.method_5803(origin.method_5701());
        splitOff = originalSize % 2 == 0 ? (int)((double)originalSize * 0.5) : 1;
        slime.method_7161(splitOff, true);
        slime.method_20803(origin.method_20802());
        slime.method_32317(origin.method_32312());
        slime.method_18799(origin.method_18798());
        originInterface.lunaSlimes$setMergeCooldown(LunaSlimesConfigValueGetter.onSplitCooldown());
        slimeInterface.lunaSlimes$setMergeCooldown(LunaSlimesConfigValueGetter.splitCooldown());
        originInterface.lunaSlimes$playWobbleAnim();
        slimeInterface.lunaSlimes$playWobbleAnim();
        LunaSlimesUtil.spawnSlimeParticles(origin);
        origin.method_73183().method_8649((class_1297)slime);
        if (LunaSlimesConfigValueGetter.splitSounds()) {
            slime.method_5783(entityType == class_1299.field_6102 ? LunaSlimes.MAGMA_SPLIT : LunaSlimes.SLIME_SPLIT, slime.method_6107(), 1.0f + (random.method_43057() - random.method_43057()) * 0.4f);
        }
        return splitOff;
    }

    public static void spawnSlimeParticles(class_1621 slime) {
        class_3218 level;
        block3: {
            block2: {
                class_1937 class_19372 = slime.method_73183();
                if (!(class_19372 instanceof class_3218)) break block2;
                level = (class_3218)class_19372;
                if (LunaSlimesConfigValueGetter.particles()) break block3;
            }
            return;
        }
        int size = slime.method_7152();
        double horizontalSpread = slime.method_17681() / 4.0f;
        double verticalSpread = slime.method_17682() / 4.0f;
        level.method_65096(slime.method_7162(), slime.method_23317(), slime.method_23323(0.6666666666666666), slime.method_23321(), level.field_9229.method_43051(size * 6, size * 12), horizontalSpread, verticalSpread, horizontalSpread, 0.05);
    }

    public static void spawnSlimeLandParticles(class_1621 slime) {
        class_1937 class_19372 = slime.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        int size = slime.method_7152();
        double horizontalSpread = slime.method_17681() / 3.5f;
        level.method_65096(slime.method_7162(), slime.method_23317(), slime.method_23318(), slime.method_23321(), level.field_9229.method_43051(size * 6, size * 8), horizontalSpread, 0.0, horizontalSpread, 0.05);
    }

    public static float getSlimeScale(class_1621 slime, float partialTick) {
        if (!(slime instanceof SlimeInterface)) {
            return slime.method_7152();
        }
        SlimeInterface slimeInterface = (SlimeInterface)slime;
        return (LunaSlimesConfigValueGetter.growAnim() ? slimeInterface.lunaSlimes$getSizeScale(partialTick) : (float)slime.method_7152()) * slimeInterface.lunaSlimes$getDeathProgress(partialTick);
    }

    public static float getSlimeWobbleAnimProgress(class_1621 slime, float partialTick) {
        SlimeInterface slimeInterface;
        block3: {
            block2: {
                if (!(slime instanceof SlimeInterface)) break block2;
                slimeInterface = (SlimeInterface)slime;
                if (LunaSlimesConfigValueGetter.wobbleAnim()) break block3;
            }
            return 0.0f;
        }
        return slimeInterface.lunaSlimes$wobbleAnimProgress(partialTick);
    }

    public static Pair<Float, Float> wobbleAnim(class_1621 slime, float partialTick) {
        float cosWobble = (float)Math.cos(((double)LunaSlimesUtil.getSlimeWobbleAnimProgress(slime, partialTick) + 0.3000220978560647) * Math.PI * 5.0);
        return Pair.of((Object)Float.valueOf(cosWobble * 0.1f + 1.0f), (Object)Float.valueOf(-(cosWobble * 0.025f) + 1.0f));
    }

    public static void setSquish(class_1621 slime, float squish) {
        if (squish < slime.field_7389) {
            slime.field_7389 = squish;
        }
    }

    public static void setStretch(class_1621 slime, float stretch) {
        if (stretch > slime.field_7389) {
            slime.field_7389 = stretch;
        }
    }

    private static class_4048 getDimensionsForSize(class_1621 slime, int size) {
        return slime.method_5864().method_18386().method_18383(0.255f * (float)size);
    }

    private static class_243 collideWithBox(class_1621 slime, class_243 deltaMovement, class_238 aABB) {
        boolean onGroundOrFalling;
        List list = slime.method_73183().method_20743((class_1297)slime, aABB.method_18804(deltaMovement));
        class_243 collide = deltaMovement.method_1027() == 0.0 ? deltaMovement : class_1297.method_20736((class_1297)slime, (class_243)deltaMovement, (class_238)aABB, (class_1937)slime.method_73183(), (List)list);
        boolean bl = onGroundOrFalling = slime.method_24828() || deltaMovement.field_1351 != collide.field_1351 && deltaMovement.field_1351 < 0.0;
        if (!(slime.method_49476() > 0.0f) || !onGroundOrFalling || deltaMovement.field_1352 == collide.field_1352 && deltaMovement.field_1350 == collide.field_1350) {
            return collide;
        }
        class_243 vec33 = class_1297.method_20736((class_1297)slime, (class_243)new class_243(deltaMovement.field_1352, (double)slime.method_49476(), deltaMovement.field_1350), (class_238)aABB, (class_1937)slime.method_73183(), (List)list);
        class_243 vec34 = class_1297.method_20736((class_1297)slime, (class_243)new class_243(0.0, (double)slime.method_49476(), 0.0), (class_238)aABB.method_1012(deltaMovement.field_1352, 0.0, deltaMovement.field_1350), (class_1937)slime.method_73183(), (List)list);
        if (vec34.field_1351 < (double)slime.method_49476()) {
            class_243 class_2432;
            class_243 vec35 = class_1297.method_20736((class_1297)slime, (class_243)new class_243(deltaMovement.field_1352, 0.0, deltaMovement.field_1350), (class_238)aABB.method_997(vec34), (class_1937)slime.method_73183(), (List)list).method_1019(vec34);
            if (class_2432.method_37268() > vec33.method_37268()) {
                vec33 = vec35;
            }
        }
        if (vec33.method_37268() > collide.method_37268()) {
            return vec33.method_1019(class_1297.method_20736((class_1297)slime, (class_243)new class_243(0.0, -vec33.field_1351 + deltaMovement.field_1351, 0.0), (class_238)aABB.method_997(vec33), (class_1937)slime.method_73183(), (List)list));
        }
        return collide;
    }
}

