/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createmetalogistics.item;

import com.simibubi.create.content.logistics.BigItemStack;
import com.xeli.createmetalogistics.component.ModDataComponents;
import com.xeli.createmetalogistics.component.TicketData;
import com.xeli.createmetalogistics.item.UUIDOnTooltipKt;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/xeli/createmetalogistics/item/TicketItem;", "Lnet/minecraft/world/item/Item;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "createmetalogistics-1.21.1"})
public final class TicketItem
extends Item {
    public TicketItem(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        TicketData ticketData = (TicketData)stack.get((Supplier)ModDataComponents.INSTANCE.getTICKET());
        if (ticketData != null) {
            Object object;
            TicketData ticketData2 = ticketData;
            boolean bl = false;
            Object[] objectArray = new Object[]{ticketData2.getList().size()};
            MutableComponent mutableComponent = Component.translatable((String)"item.createmetalogistics.ticket.tooltip1", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            tooltipComponents.add((Component)mutableComponent);
            if (tooltipFlag.hasShiftDown()) {
                object = ticketData2.getPackageAddress();
            } else if (ticketData2.getPackageAddress().length() > 18) {
                String string = ticketData2.getPackageAddress().substring(18);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = string + "...";
            } else {
                object = ticketData2.getPackageAddress();
            }
            String stringToDisplay = object;
            Object[] objectArray2 = new Object[]{stringToDisplay};
            MutableComponent mutableComponent2 = Component.translatable((String)"item.createmetalogistics.ticket.tooltip2", (Object[])objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
            tooltipComponents.add((Component)mutableComponent2);
            if (tooltipFlag.hasAltDown()) {
                objectArray2 = new Object[]{UUIDOnTooltipKt.forTooltipLong(ticketData2.getRequestNetworkOwnerId())};
                MutableComponent mutableComponent3 = Component.translatable((String)"item.createmetalogistics.ticket.tooltip3", (Object[])objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
                tooltipComponents.add((Component)mutableComponent3);
            }
            if (tooltipFlag.hasAltDown()) {
                objectArray2 = new Object[]{UUIDOnTooltipKt.forTooltipLong(ticketData2.getOriginNetworkId())};
                MutableComponent mutableComponent4 = Component.translatable((String)"item.createmetalogistics.ticket.tooltip4", (Object[])objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"translatable(...)");
                tooltipComponents.add((Component)mutableComponent4);
            }
            int maxItems = tooltipFlag.hasShiftDown() ? 10 : 1;
            int itemRange = Math.min(maxItems, ticketData2.getList().size());
            for (int i = 0; i < itemRange; ++i) {
                BigItemStack bigItemStack = ticketData2.getList().get(i);
                MutableComponent mutableComponent5 = Component.literal((String)"  ").append(bigItemStack.stack.getHoverName()).append(" x" + bigItemStack.count).withStyle(ChatFormatting.DARK_GRAY);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent5, (String)"withStyle(...)");
                tooltipComponents.add((Component)mutableComponent5);
                bigItemStack.stack.getHoverName().plainCopy();
            }
            if (ticketData2.getList().size() > maxItems) {
                MutableComponent mutableComponent6 = Component.literal((String)"  ...").withStyle(ChatFormatting.DARK_GRAY);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent6, (String)"withStyle(...)");
                tooltipComponents.add((Component)mutableComponent6);
            }
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

