/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createmetalogistics.screen.custom;

import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.xeli.createmetalogistics.LogisticsMod;
import com.xeli.createmetalogistics.ModBlocks;
import com.xeli.createmetalogistics.content.filterrequester.ConfigureFilterRequesterPacket;
import com.xeli.createmetalogistics.content.filterrequester.FilterPolicy;
import com.xeli.createmetalogistics.content.filterrequester.FilterRequesterBlockEntity;
import com.xeli.createmetalogistics.screen.ModMenuTypes;
import com.xeli.createmetalogistics.util.PlayUiSoundKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 B2\u00020\u0001:\u0001BB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0006\u0010\u001f\u001a\u00020 J\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%J0\u0010'\u001a\u00020 2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u000e\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\"2\u0006\u0010/\u001a\u000200J\u000e\u00102\u001a\u00020 2\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020 2\u0006\u00106\u001a\u00020\"J\u000e\u00107\u001a\u00020 2\u0006\u00106\u001a\u000208J(\u00109\u001a\u00020 2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010:\u001a\u00020 2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020\u0003H\u0016J\u0010\u0010>\u001a\u00020\"2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010?\u001a\u00020 2\u0006\u0010@\u001a\u00020\u0005H\u0002J\u0010\u0010A\u001a\u00020 2\u0006\u0010@\u001a\u00020\u0005H\u0002R\u0011\u0010\u0006\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006C"}, d2={"Lcom/xeli/createmetalogistics/screen/custom/FilterRequesterMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "", "inv", "Lnet/minecraft/world/entity/player/Inventory;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/level/block/entity/BlockEntity;)V", "extraData", "Lnet/minecraft/network/FriendlyByteBuf;", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/FriendlyByteBuf;)V", "Lcom/xeli/createmetalogistics/content/filterrequester/FilterRequesterBlockEntity;", "getBlockEntity", "()Lcom/xeli/createmetalogistics/content/filterrequester/FilterRequesterBlockEntity;", "level", "Lnet/minecraft/world/level/Level;", "ghostSlotDescription", "Lnet/minecraft/network/chat/MutableComponent;", "getGhostSlotDescription", "()Lnet/minecraft/network/chat/MutableComponent;", "ghostInventory", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getGhostInventory", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "ghostSlots", "", "Lnet/neoforged/neoforge/items/SlotItemHandler;", "getGhostSlots", "()Ljava/util/List;", "configureOnClose", "", "scrollOnSlot", "", "slot", "scrollX", "", "scrollY", "performGhostAction", "slotId", "button", "clickType", "Lnet/minecraft/world/inventory/ClickType;", "player", "Lnet/minecraft/world/entity/player/Player;", "filterItemChanged", "stack", "Lnet/minecraft/world/item/ItemStack;", "canUseAsFilterItem", "addressChanged", "newAddress", "", "allowPartialChanged", "newMode", "filterPolicyChanged", "Lcom/xeli/createmetalogistics/content/filterrequester/FilterPolicy;", "clicked", "removed", "quickMoveStack", "playerIn", "pIndex", "stillValid", "addPlayerInventory", "playerInventory", "addPlayerHotbar", "Companion", "createmetalogistics-1.21.1"})
public final class FilterRequesterMenu
extends AbstractContainerMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FilterRequesterBlockEntity blockEntity;
    @NotNull
    private final Level level;
    @NotNull
    private final MutableComponent ghostSlotDescription;
    @NotNull
    private final ItemStackHandler ghostInventory;
    @NotNull
    private final List<SlotItemHandler> ghostSlots;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 9 + PLAYER_INVENTORY_SLOT_COUNT;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 0 + VANILLA_SLOT_COUNT;
    private static final int TE_INVENTORY_SLOT_COUNT = 0;

    /*
     * WARNING - void declaration
     */
    public FilterRequesterMenu(int containerId, @NotNull Inventory inv, @NotNull BlockEntity blockEntity) {
        void $this$ghostSlots_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        super((MenuType)ModMenuTypes.INSTANCE.getFILTER_REQUESTER_MENU().get(), containerId);
        this.blockEntity = (FilterRequesterBlockEntity)blockEntity;
        Level level = inv.player.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        this.level = level;
        MutableComponent mutableComponent = Component.translatable((String)"menu.createmetalogistics.filter_requester.input_slot");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        this.ghostSlotDescription = mutableComponent;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.ghostInventory = new ItemStackHandler(1);
        FilterItemStack filter = this.blockEntity.getFilterItemStack();
        Object fakeItemStack = filter == null ? ItemStack.EMPTY : filter.item();
        this.ghostInventory.setStackInSlot(0, fakeItemStack);
        List list = CollectionsKt.createListBuilder();
        fakeItemStack = list;
        FilterRequesterMenu filterRequesterMenu = this;
        boolean bl = false;
        SlotItemHandler slotItemHandler = new SlotItemHandler((IItemHandler)this.ghostInventory, 0, 8, 18);
        $this$ghostSlots_u24lambda_u240.add(slotItemHandler);
        this.addSlot((Slot)slotItemHandler);
        filterRequesterMenu.ghostSlots = CollectionsKt.build((List)list);
    }

    @NotNull
    public final FilterRequesterBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public FilterRequesterMenu(int containerId, @NotNull Inventory inv, @NotNull FriendlyByteBuf extraData) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        Intrinsics.checkNotNullParameter((Object)extraData, (String)"extraData");
        BlockEntity blockEntity = inv.player.level().getBlockEntity(extraData.readBlockPos());
        Intrinsics.checkNotNull((Object)blockEntity);
        this(containerId, inv, blockEntity);
    }

    @NotNull
    public final MutableComponent getGhostSlotDescription() {
        return this.ghostSlotDescription;
    }

    @NotNull
    public final ItemStackHandler getGhostInventory() {
        return this.ghostInventory;
    }

    @NotNull
    public final List<SlotItemHandler> getGhostSlots() {
        return this.ghostSlots;
    }

    public final void configureOnClose() {
        BlockPos blockPos = this.blockEntity.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        FilterItemStack filterItemStack = this.blockEntity.getFilterItemStack();
        if (filterItemStack == null || (filterItemStack = filterItemStack.item()) == null) {
            filterItemStack = ItemStack.EMPTY;
        }
        FilterItemStack filterItemStack2 = filterItemStack;
        Intrinsics.checkNotNull((Object)filterItemStack2);
        PacketDistributor.sendToServer((CustomPacketPayload)new ConfigureFilterRequesterPacket(blockPos, (ItemStack)filterItemStack2, this.blockEntity.getAmountToRequest(), this.blockEntity.getEncodedTargetAddress(), this.blockEntity.getAllowPartialRequests(), this.blockEntity.getFilterPolicy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final boolean scrollOnSlot(@NotNull SlotItemHandler slot, double scrollX, double scrollY) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        boolean remove = scrollY < 0.0;
        int transfer = Mth.ceil((double)Math.abs(scrollY)) * (Screen.hasControlDown() ? 10 : 1);
        if (this.blockEntity.getFilterItemStack() != null) {
            int oldCount = this.blockEntity.getAmountToRequest();
            int minStackSize = 1;
            int maxStackSize = 256;
            int newCount = Math.max(minStackSize, Math.min(maxStackSize, remove ? oldCount - transfer : oldCount + transfer));
            SoundEvent soundEvent = SoundEvents.WOOL_STEP;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"WOOL_STEP");
            PlayUiSoundKt.playUiSound(soundEvent, 0.75f, 1.2f);
            SoundEvent soundEvent2 = SoundEvents.BAMBOO_WOOD_STEP;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent2, (String)"BAMBOO_WOOD_STEP");
            PlayUiSoundKt.playUiSound(soundEvent2, 0.75f, 0.8f);
            this.blockEntity.setAmountToRequest(newCount);
            return true;
        }
        return false;
    }

    private final void performGhostAction(SlotItemHandler slot, int slotId, int button, ClickType clickType, Player player) {
        if (clickType == ClickType.THROW) {
            return;
        }
        ItemStack carriedStack = this.getCarried();
        if (clickType == ClickType.CLONE) {
            if (player.isCreative() && carriedStack.isEmpty()) {
                FilterItemStack entry;
                FilterItemStack filterItemStack = entry = this.blockEntity.getFilterItemStack();
                ItemStack itemStack = (filterItemStack != null ? filterItemStack.item() : ItemStack.EMPTY).copy();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
                ItemStack stackInSlot = itemStack;
                stackInSlot.setCount(((Number)stackInSlot.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64)).intValue());
                this.setCarried(stackInSlot);
                return;
            }
            return;
        }
        Intrinsics.checkNotNull((Object)carriedStack);
        if (this.canUseAsFilterItem(carriedStack) || carriedStack.isEmpty()) {
            ItemStack insert = carriedStack.isEmpty() ? ItemStack.EMPTY : carriedStack.copy();
            slot.set(insert.copyWithCount(1));
            this.blockEntity.setFilterItemStack(FilterItemStack.of((ItemStack)insert.copyWithCount(1)));
        }
    }

    public final void filterItemChanged(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        FilterItemStack filterItemStack = FilterItemStack.of((ItemStack)stack.copyWithCount(1));
        if (filterItemStack.isFilterItem()) {
            this.blockEntity.setFilterItemStack(filterItemStack);
        }
    }

    public final boolean canUseAsFilterItem(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.blockEntity.canUseAsFilterItem(stack);
    }

    public final void addressChanged(@NotNull String newAddress) {
        Intrinsics.checkNotNullParameter((Object)newAddress, (String)"newAddress");
        this.blockEntity.setEncodedTargetAddress(newAddress);
    }

    public final void allowPartialChanged(boolean newMode) {
        this.blockEntity.setAllowPartialRequests(newMode);
    }

    public final void filterPolicyChanged(@NotNull FilterPolicy newMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)newMode), (String)"newMode");
        this.blockEntity.setFilterPolicy(newMode);
    }

    public void clicked(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        for (SlotItemHandler slot : this.ghostSlots) {
            int newIndex = slot.getSlotIndex() + TE_INVENTORY_FIRST_SLOT_INDEX + 0;
            if (slotId != newIndex) continue;
            this.performGhostAction(slot, slotId, button, clickType, player);
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    public void removed(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.removed(player);
        if (this.level.isClientSide) {
            this.configureOnClose();
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int pIndex) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        Object object = this.slots.get(pIndex);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Slot sourceSlot = (Slot)object;
        if (!sourceSlot.hasItem()) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 0 + VANILLA_SLOT_COUNT) {
            Intrinsics.checkNotNull((Object)copyOfSourceStack);
            if (this.canUseAsFilterItem(copyOfSourceStack)) {
                this.ghostSlots.get(0).set(copyOfSourceStack);
                this.filterItemChanged(copyOfSourceStack);
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        } else if (pIndex < TE_INVENTORY_FIRST_SLOT_INDEX + 0) {
            if (!this.moveItemStackTo(sourceStack, 0, 0 + VANILLA_SLOT_COUNT, false)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        } else {
            LogisticsMod.Companion.getLOGGER().warn("Invalid slotIndex:" + pIndex);
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        Intrinsics.checkNotNull((Object)copyOfSourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return AbstractContainerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)ModBlocks.INSTANCE.getFilterRequesterBlock().get()));
    }

    private final void addPlayerInventory(Inventory playerInventory) {
        int imageHeight = 178;
        int inventoryMarginTop = imageHeight - 82;
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, inventoryMarginTop + i * 18));
            }
        }
    }

    private final void addPlayerHotbar(Inventory playerInventory) {
        int imageHeight = 178;
        int inventoryMarginTop = imageHeight - 82;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, inventoryMarginTop + 58));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/xeli/createmetalogistics/screen/custom/FilterRequesterMenu$Companion;", "", "<init>", "()V", "HOTBAR_SLOT_COUNT", "", "PLAYER_INVENTORY_ROW_COUNT", "PLAYER_INVENTORY_COLUMN_COUNT", "PLAYER_INVENTORY_SLOT_COUNT", "VANILLA_SLOT_COUNT", "VANILLA_FIRST_SLOT_INDEX", "TE_INVENTORY_FIRST_SLOT_INDEX", "TE_INVENTORY_SLOT_COUNT", "createmetalogistics-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

